/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.filtering;

import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.graylog2.database.filtering.Filter;

record RangeFilter(String field, Object from, Object to) implements Filter
{
    @Override
    public Bson toBson() {
        ArrayList<Bson> rangeFilters = new ArrayList<Bson>(2);
        if (this.from() != null) {
            rangeFilters.add(Filters.gte((String)this.field(), (Object)this.from()));
        }
        if (this.to() != null) {
            rangeFilters.add(Filters.lte((String)this.field(), (Object)this.to()));
        }
        if (!rangeFilters.isEmpty()) {
            return Filters.and(rangeFilters);
        }
        return new BsonDocument();
    }
}

