/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.IgnoreIndexTemplate;
import org.graylog2.indexer.IndexMappingTemplate;
import org.graylog2.indexer.IndexTemplateProvider;
import org.graylog2.indexer.cluster.Node;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.shared.utilities.StringUtils;
import org.graylog2.storage.SearchVersion;

@Singleton
public class IndexMappingFactory {
    private final Node node;
    private final Map<String, IndexTemplateProvider> providers;

    @Inject
    public IndexMappingFactory(Node node, Map<String, IndexTemplateProvider> providers) {
        this.node = node;
        this.providers = providers;
    }

    @Nonnull
    public IndexMappingTemplate createIndexMapping(@Nonnull IndexSetConfig indexSetConfig) throws IgnoreIndexTemplate {
        SearchVersion elasticsearchVersion = this.node.getVersion().orElseThrow(() -> new ElasticsearchException("Unable to retrieve Elasticsearch version."));
        String templateType = indexSetConfig.indexTemplateType().orElse("messages");
        return this.resolveIndexMappingTemplateProvider(templateType).create(elasticsearchVersion, indexSetConfig);
    }

    private IndexTemplateProvider resolveIndexMappingTemplateProvider(@Nonnull String templateType) {
        if (this.providers.containsKey(templateType)) {
            return this.providers.get(templateType);
        }
        throw new IllegalStateException(StringUtils.f("No index template provider found for type '%s'", templateType));
    }
}

