/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indexset;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.stream.Collectors;
import org.graylog2.indexer.fieldtypes.FieldTypeMapper;
import org.graylog2.indexer.fieldtypes.FieldTypes;
import org.graylog2.indexer.indexset.CustomFieldMappings;

public record CustomFieldMapping(@JsonProperty(value="field") String fieldName, @JsonProperty(value="type") String type) {
    public String toPhysicalType() {
        CustomFieldMappings.TypeDescription typeDescription = CustomFieldMappings.AVAILABLE_TYPES.get(this.type());
        if (typeDescription == null) {
            throw new IllegalStateException("Invalid type specified: " + this.type());
        }
        Map<FieldTypes.Type, String> reverseMap = FieldTypeMapper.TYPE_MAP.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("half_float") && !((String)entry.getKey()).equals("scaled_float")).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        return reverseMap.get(typeDescription.type());
    }
}

