/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.searches;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSortedSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.database.NotFoundException;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.ranges.IndexRangeService;
import org.graylog2.indexer.results.ChunkedResult;
import org.graylog2.indexer.results.CountResult;
import org.graylog2.indexer.results.FieldStatsResult;
import org.graylog2.indexer.results.SearchResult;
import org.graylog2.indexer.searches.ChunkCommand;
import org.graylog2.indexer.searches.SearchesAdapter;
import org.graylog2.indexer.searches.SearchesConfig;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.indexer.searches.timeranges.TimeRanges;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamService;

@Singleton
public class Searches {
    private static final Pattern filterStreamIdPattern = Pattern.compile("^(.+[^\\p{Alnum}])?streams:([\\p{XDigit}]+)");
    private final IndexRangeService indexRangeService;
    private final Timer esRequestTimer;
    private final Histogram esTimeRangeHistogram;
    private final Counter esTotalSearchesCounter;
    private final StreamService streamService;
    private final Indices indices;
    private final IndexSetRegistry indexSetRegistry;
    private final SearchesAdapter searchesAdapter;

    @Inject
    public Searches(IndexRangeService indexRangeService, MetricRegistry metricRegistry, StreamService streamService, Indices indices, IndexSetRegistry indexSetRegistry, SearchesAdapter searchesAdapter) {
        this.indexRangeService = Objects.requireNonNull(indexRangeService, "indexRangeService");
        this.esRequestTimer = metricRegistry.timer(MetricRegistry.name(Searches.class, (String[])new String[]{"elasticsearch", "requests"}));
        this.esTimeRangeHistogram = metricRegistry.histogram(MetricRegistry.name(Searches.class, (String[])new String[]{"elasticsearch", "ranges"}));
        this.esTotalSearchesCounter = metricRegistry.counter(MetricRegistry.name(Searches.class, (String[])new String[]{"elasticsearch", "total-searches"}));
        this.streamService = Objects.requireNonNull(streamService, "streamService");
        this.indices = Objects.requireNonNull(indices, "indices");
        this.indexSetRegistry = Objects.requireNonNull(indexSetRegistry, "indexSetRegistry");
        this.searchesAdapter = searchesAdapter;
    }

    public CountResult count(String query, TimeRange range) {
        return this.count(query, range, null);
    }

    public CountResult count(String query, TimeRange range, String filter) {
        Set<String> affectedIndices = this.determineAffectedIndices(range, filter);
        if (affectedIndices.isEmpty()) {
            return CountResult.empty();
        }
        CountResult result = this.searchesAdapter.count(affectedIndices, query, range, filter);
        this.recordEsMetrics(result.tookMs(), range);
        return result;
    }

    @Deprecated
    public ChunkedResult scroll(String query, TimeRange range, int limit, int offset, List<String> fields, String filter, int batchSize) {
        Set<String> affectedIndices = this.determineAffectedIndices(range, filter);
        Set<String> indexWildcards = this.indexSetRegistry.getForIndices(affectedIndices).stream().map(IndexSet::getIndexWildcard).collect(Collectors.toSet());
        Sorting sorting = new Sorting("_doc", Sorting.Direction.ASC);
        ChunkCommand.Builder scrollCommandBuilder = ChunkCommand.builder().query(query).range(range).offset(offset).fields(fields).filter(filter).sorting(sorting).indices(indexWildcards);
        scrollCommandBuilder = limit > 0 ? scrollCommandBuilder.limit(limit) : scrollCommandBuilder;
        scrollCommandBuilder = batchSize != -1 ? scrollCommandBuilder.batchSize(batchSize) : scrollCommandBuilder;
        ChunkedResult result = this.searchesAdapter.scroll(scrollCommandBuilder.build());
        this.recordEsMetrics(result.tookMs(), range);
        return result;
    }

    public SearchResult search(String query, TimeRange range, int limit, int offset, Sorting sorting) {
        return this.search(query, null, range, limit, offset, sorting);
    }

    public SearchResult search(String query, String filter, TimeRange range, int limit, int offset, Sorting sorting) {
        SearchesConfig searchesConfig = SearchesConfig.builder().query(query).filter(filter).range(range).limit(limit).offset(offset).sorting(sorting).build();
        return this.search(searchesConfig);
    }

    public SearchResult search(SearchesConfig config) {
        Set<IndexRange> indexRanges = this.determineAffectedIndicesWithRanges(config.range(), config.filter());
        Set<String> indices = this.extractIndexNamesFromIndexRanges(indexRanges);
        SearchResult result = this.searchesAdapter.search(indices, indexRanges, config);
        this.recordEsMetrics(result.tookMs(), config.range());
        return result;
    }

    public FieldStatsResult fieldStats(String field, String query, TimeRange range) {
        return this.fieldStats(field, query, null, range, true, true, true);
    }

    public FieldStatsResult fieldStats(String field, String query, String filter, TimeRange range, boolean includeCardinality, boolean includeStats, boolean includeCount) {
        Set<String> indices = this.indicesContainingField(this.determineAffectedIndices(range, filter), field);
        FieldStatsResult result = this.searchesAdapter.fieldStats(query, filter, range, indices, field, includeCardinality, includeStats, includeCount);
        this.recordEsMetrics(result.tookMs(), range);
        return result;
    }

    private Set<String> indicesContainingField(Set<String> strings, String field) {
        return this.indices.getAllMessageFieldsForIndices(strings.toArray(new String[0])).entrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(field)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private void recordEsMetrics(long tookMs, TimeRange range) {
        this.esTotalSearchesCounter.inc();
        this.esRequestTimer.update(tookMs, TimeUnit.MILLISECONDS);
        if (range != null) {
            this.esTimeRangeHistogram.update(TimeRanges.toSeconds(range));
        }
    }

    public static Optional<String> extractStreamId(String filter) {
        if (Strings.isNullOrEmpty((String)filter)) {
            return Optional.empty();
        }
        Matcher streamIdMatcher = filterStreamIdPattern.matcher(filter);
        if (streamIdMatcher.find()) {
            return Optional.of(streamIdMatcher.group(2));
        }
        return Optional.empty();
    }

    @VisibleForTesting
    Set<String> determineAffectedIndices(TimeRange range, @Nullable String filter) {
        return this.extractIndexNamesFromIndexRanges(this.determineAffectedIndicesWithRanges(range, filter));
    }

    private Set<String> extractIndexNamesFromIndexRanges(Set<IndexRange> indexRanges) {
        return indexRanges.stream().map(IndexRange::indexName).collect(Collectors.toSet());
    }

    @VisibleForTesting
    Set<IndexRange> determineAffectedIndicesWithRanges(TimeRange range, @Nullable String filter) {
        Optional<String> streamId = Searches.extractStreamId(filter);
        IndexSet indexSet = null;
        if (streamId.isPresent()) {
            try {
                Stream stream = this.streamService.load(streamId.get());
                indexSet = stream.getIndexSet();
            }
            catch (NotFoundException stream) {
                // empty catch block
            }
        }
        ImmutableSortedSet.Builder indices = ImmutableSortedSet.orderedBy(IndexRange.COMPARATOR);
        SortedSet<IndexRange> indexRanges = this.indexRangeService.find(range.getFrom(), range.getTo());
        Set<String> affectedIndexNames = indexRanges.stream().map(IndexRange::indexName).collect(Collectors.toSet());
        Set eventIndexSets = this.indexSetRegistry.getForIndices(affectedIndexNames).stream().filter(indexSet1 -> "events".equals(indexSet1.getConfig().indexTemplateType().orElse("messages"))).collect(Collectors.toSet());
        for (IndexRange indexRange : indexRanges) {
            boolean streamInCurrentIndexSet;
            if (indexSet == null && filter == null) {
                if (eventIndexSets.stream().anyMatch(set -> set.isManagedIndex(indexRange.indexName()))) continue;
                indices.add((Object)indexRange);
                continue;
            }
            boolean streamInIndexRange = streamId.isPresent() && indexRange.streamIds() != null && indexRange.streamIds().contains(streamId.get());
            boolean bl = streamInCurrentIndexSet = indexSet != null && indexSet.isManagedIndex(indexRange.indexName());
            if (streamInIndexRange) {
                indices.add((Object)indexRange);
            }
            if (!streamInCurrentIndexSet) continue;
            indices.add((Object)indexRange);
        }
        return indices.build();
    }
}

