/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.initializers;

import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.initializers.BufferSynchronizerService;
import org.graylog2.outputs.DefaultMessageOutput;
import org.graylog2.outputs.OutputRegistry;
import org.graylog2.plugin.outputs.MessageOutput;
import org.graylog2.system.shutdown.GracefulShutdownHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OutputSetupService
extends AbstractIdleService {
    private static final Logger LOG = LoggerFactory.getLogger(OutputSetupService.class);
    private final OutputRegistry outputRegistry;
    private final MessageOutput defaultMessageOutput;

    @Inject
    public OutputSetupService(OutputRegistry outputRegistry, BufferSynchronizerService bufferSynchronizerService, MetricRegistry metricRegistry, @DefaultMessageOutput MessageOutput defaultMessageOutput) {
        this.outputRegistry = outputRegistry;
        this.defaultMessageOutput = defaultMessageOutput;
        bufferSynchronizerService.addListener(new Service.Listener(){

            public void terminated(Service.State from) {
                OutputSetupService.this.shutDownRunningOutputs();
            }
        }, this.executorService(metricRegistry));
    }

    private ExecutorService executorService(MetricRegistry metricRegistry) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("output-setup-service-%d").build();
        return new InstrumentedExecutorService(Executors.newSingleThreadExecutor(threadFactory), metricRegistry, MetricRegistry.name(((Object)((Object)this)).getClass(), (String[])new String[]{"executor-service"}));
    }

    private void shutDownRunningOutputs() {
        for (MessageOutput output : this.outputRegistry.getMessageOutputs()) {
            if (output instanceof GracefulShutdownHook) continue;
            try {
                LOG.info("Stopping output {}", (Object)output.getClass().getName());
                output.stop();
            }
            catch (Exception e) {
                LOG.error("Error stopping output", (Throwable)e);
            }
        }
    }

    protected void startUp() throws Exception {
        this.defaultMessageOutput.initialize();
    }

    protected void shutDown() throws Exception {
    }
}

