/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.codecs;

import java.util.Map;
import javax.inject.Inject;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.inputs.codecs.Codec;

public class CodecFactory {
    private Map<String, Codec.Factory<? extends Codec>> codecFactory;

    @Inject
    public CodecFactory(Map<String, Codec.Factory<? extends Codec>> codecFactory) {
        this.codecFactory = codecFactory;
    }

    public Map<String, Codec.Factory<? extends Codec>> getFactory() {
        return this.codecFactory;
    }

    public Codec create(String type, Configuration configuration) {
        Codec.Factory<? extends Codec> factory = this.codecFactory.get(type);
        if (factory == null) {
            throw new IllegalArgumentException("Codec type " + type + " does not exist.");
        }
        return factory.create(configuration);
    }
}

