/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.codecs;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.BooleanField;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.inputs.annotations.Codec;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.AbstractCodec;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.graylog2.plugin.journal.RawMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Codec(name="jsonpath", displayName="JSON Path")
public class JsonPathCodec
extends AbstractCodec {
    private static final Logger LOG = LoggerFactory.getLogger(JsonPathCodec.class);
    public static final String CK_PATH = "path";
    public static final String CK_SOURCE = "source";
    public static final String CK_FLATTEN = "enable_flattening";
    private final JsonPath jsonPath;
    private final boolean flatten;
    private final ObjectMapper objectMapper;

    @AssistedInject
    public JsonPathCodec(@Assisted Configuration configuration, ObjectMapper objectMapper) {
        super(configuration);
        String pathString = configuration.getString(CK_PATH);
        this.jsonPath = pathString == null ? null : JsonPath.compile((String)pathString, (Predicate[])new Predicate[0]);
        this.flatten = configuration.getBoolean(CK_FLATTEN);
        this.objectMapper = objectMapper;
    }

    @Override
    @Nullable
    public Message decode(@Nonnull RawMessage rawMessage) {
        HashMap<String, Object> fields = new HashMap();
        if (this.flatten) {
            json = new String(rawMessage.getPayload(), this.charset);
            try {
                fields = this.flatten(json);
            }
            catch (JsonFlattenException e) {
                LOG.warn("JSON contains type not supported by flatten method.", (Throwable)e);
            }
            catch (JsonProcessingException e) {
                LOG.warn("Could not parse JSON.", (Throwable)e);
            }
        } else {
            if (this.jsonPath == null) {
                return null;
            }
            json = new String(rawMessage.getPayload(), this.charset);
            fields = this.read(json);
        }
        Message message = new Message(this.buildShortMessage(fields), this.configuration.getString(CK_SOURCE), rawMessage.getTimestamp());
        message.addFields(fields);
        return message;
    }

    @VisibleForTesting
    protected Map<String, Object> read(String json) {
        Object result = this.jsonPath.read(json);
        HashMap fields = Maps.newHashMap();
        if (result instanceof Integer || result instanceof Double || result instanceof Long) {
            fields.put("result", result);
        } else if (result instanceof List) {
            List list = (List)result;
            if (!list.isEmpty()) {
                fields.put("result", list.get(0).toString());
            }
        } else {
            fields.put("result", result.toString());
        }
        return fields;
    }

    @VisibleForTesting
    protected String buildShortMessage(Map<String, Object> fields) {
        StringBuilder shortMessage = new StringBuilder();
        shortMessage.append("JSON API poll result: ");
        if (!this.flatten) {
            shortMessage.append(this.jsonPath.getPath());
        }
        shortMessage.append(" -> ");
        if (fields.toString().length() > 50) {
            shortMessage.append(fields.toString().substring(0, 50)).append("[...]");
        } else {
            shortMessage.append(fields.toString());
        }
        return shortMessage.toString();
    }

    public Map<String, Object> flatten(String json) throws JsonFlattenException, JsonProcessingException {
        return this.flatten("", this.objectMapper.readTree(json));
    }

    private Map<String, Object> flatten(String currentPath, JsonNode jsonNode) throws JsonFlattenException {
        if (jsonNode.isObject()) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            Iterator iter = objectNode.fields();
            Object pathPrefix = currentPath.isEmpty() ? "" : currentPath + ".";
            ImmutableMap.Builder builder = ImmutableMap.builder();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                builder.putAll(this.flatten((String)pathPrefix + (String)entry.getKey(), (JsonNode)entry.getValue()));
            }
            return builder.build();
        }
        if (jsonNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < arrayNode.size(); ++i) {
                builder.putAll(this.flatten(currentPath + i, arrayNode.get(i)));
            }
            return builder.build();
        }
        if (jsonNode.isTextual()) {
            TextNode textNode = (TextNode)jsonNode;
            return Map.of(currentPath, textNode.toString());
        }
        if (jsonNode.isNumber()) {
            NumericNode numericNode = (NumericNode)jsonNode;
            return Map.of(currentPath, numericNode.numberValue());
        }
        if (jsonNode.isBoolean()) {
            BooleanNode booleanNode = (BooleanNode)jsonNode;
            return Map.of(currentPath, booleanNode.asBoolean());
        }
        throw new JsonFlattenException("Warning: JSON contains type not supported by the flatten method. JsonNode: " + jsonNode);
    }

    @Override
    @Nullable
    public CodecAggregator getAggregator() {
        return null;
    }

    public static class JsonFlattenException
    extends Exception {
        public JsonFlattenException(String errorMessage) {
            super(errorMessage);
        }
    }

    public static class Descriptor
    extends AbstractCodec.Descriptor {
        @Inject
        public Descriptor() {
            super(JsonPathCodec.class.getAnnotation(Codec.class).displayName());
        }
    }

    @ConfigClass
    public static class Config
    extends AbstractCodec.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest r = super.getRequestedConfiguration();
            r.addField(new TextField(JsonPathCodec.CK_PATH, "JSON path of data to extract", "$.store.book[1].number_of_orders", "Path to the value you want to extract from the JSON response. Take a look at the documentation for a more detailed explanation.", ConfigurationField.Optional.NOT_OPTIONAL));
            r.addField(new TextField(JsonPathCodec.CK_SOURCE, "Message source", "yourapi", "What to use as source field of the resulting message.", ConfigurationField.Optional.NOT_OPTIONAL));
            r.addField(new BooleanField(JsonPathCodec.CK_FLATTEN, "Flatten JSON", false, "If set, the whole JSON will be flattened and returned as message fields."));
            return r;
        }

        @Override
        public void overrideDefaultValues(@Nonnull ConfigurationRequest cr) {
        }
    }

    @FactoryClass
    public static interface Factory
    extends Codec.Factory<JsonPathCodec> {
        @Override
        public JsonPathCodec create(Configuration var1);

        @Override
        public Config getConfig();

        @Override
        public Descriptor getDescriptor();
    }
}

