/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.codecs.gelf;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.graylog2.plugin.ResolvableInetSocketAddress;
import org.graylog2.plugin.Tools;

public class GELFMessage {
    private final byte[] payload;
    private final ResolvableInetSocketAddress sourceAddress;

    public GELFMessage(byte[] payload) {
        this(payload, null);
    }

    public GELFMessage(byte[] payload, ResolvableInetSocketAddress sourceAddress) {
        this.payload = payload;
        this.sourceAddress = sourceAddress;
    }

    public Type getGELFType() {
        if (this.payload.length < 2) {
            throw new IllegalStateException("GELF message is too short. Not even the type header would fit.");
        }
        return Type.determineType(this.payload[0], this.payload[1]);
    }

    @Deprecated
    public String getJSON() {
        return this.getJSON(Long.MAX_VALUE);
    }

    public String getJSON(long maxBytes) {
        return this.getJSON(maxBytes, StandardCharsets.UTF_8);
    }

    public String getJSON(long maxBytes, Charset charset) {
        try {
            switch (this.getGELFType()) {
                case ZLIB: {
                    return Tools.decompressZlib(this.payload, maxBytes);
                }
                case GZIP: {
                    return Tools.decompressGzip(this.payload, maxBytes);
                }
                case UNCOMPRESSED: {
                    return new String(this.payload, charset);
                }
                case CHUNKED: 
                case UNSUPPORTED: {
                    throw new IllegalStateException("Unknown GELF type. Not supported.");
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unexpected encoding", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to decompress the GELF message payload", e);
        }
        return null;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    @Nullable
    public ResolvableInetSocketAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public static enum Type {
        UNSUPPORTED(0, 0),
        ZLIB(120, -100),
        GZIP(31, -117),
        CHUNKED(30, 15),
        UNCOMPRESSED(-1, -1);

        private static final int HEADER_SIZE = 2;
        private final byte first;
        private final byte second;

        private Type(byte first, byte second) {
            this.first = first;
            this.second = second;
        }

        static Type determineType(byte first, byte second) {
            if (first == ZLIB.first()) {
                int secondInt = second;
                if (secondInt < 0) {
                    secondInt += 256;
                }
                if ((256 * first + secondInt) % 31 == 0) {
                    return ZLIB;
                }
                return UNSUPPORTED;
            }
            if (first == GZIP.first()) {
                if (second == GZIP.second()) {
                    return GZIP;
                }
                return UNSUPPORTED;
            }
            if (first == CHUNKED.first()) {
                if (second == CHUNKED.second()) {
                    return CHUNKED;
                }
                return UNSUPPORTED;
            }
            return UNCOMPRESSED;
        }

        public byte first() {
            return this.first;
        }

        public byte second() {
            return this.second;
        }
    }
}

