/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.encryption;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bson.Document;
import org.graylog2.database.MongoConnection;
import org.graylog2.inputs.encryption.EncryptedInputConfigs;
import org.graylog2.jackson.TypeReferences;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.security.encryption.EncryptedValue;
import org.graylog2.security.encryption.EncryptedValueMapperConfig;
import org.graylog2.shared.inputs.MessageInputFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EncryptedInputConfigMigration
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptedInputConfigMigration.class);
    protected final ClusterConfigService clusterConfigService;
    protected final MongoConnection mongoConnection;
    private final MessageInputFactory messageInputFactory;
    private final ObjectMapper objectMapper;
    private final ObjectMapper dbObjectMapper;

    public EncryptedInputConfigMigration(ClusterConfigService clusterConfigService, MongoConnection mongoConnection, MessageInputFactory messageInputFactory, ObjectMapper objectMapper) {
        this.messageInputFactory = messageInputFactory;
        this.clusterConfigService = clusterConfigService;
        this.mongoConnection = mongoConnection;
        this.objectMapper = objectMapper.copy();
        this.dbObjectMapper = objectMapper.copy();
        EncryptedValueMapperConfig.enableDatabase(this.dbObjectMapper);
    }

    @Override
    public void upgrade() {
        Map<String, Set<String>> encryptedFieldsByInputType = this.getEncryptedFieldsByInputType();
        if (this.getMigratedField().equals(encryptedFieldsByInputType)) {
            LOG.debug("Migration already completed.");
            return;
        }
        MongoCollection<Document> collection = this.getCollection();
        FindIterable documents = collection.find(Filters.in((String)"type", encryptedFieldsByInputType.keySet()));
        documents.forEach(doc -> {
            HashMap config = new HashMap((Map)doc.getOrDefault((Object)"configuration", Map.of()));
            Set encryptedFields = encryptedFieldsByInputType.getOrDefault((String)doc.get((Object)"type"), Set.of());
            encryptedFields.forEach(fieldName -> {
                Object value = config.get(fieldName);
                if (config.containsKey(fieldName) && !(value instanceof Map)) {
                    EncryptedValue encryptedValue = (EncryptedValue)this.objectMapper.convertValue(value, EncryptedValue.class);
                    config.put(fieldName, this.dbObjectMapper.convertValue((Object)encryptedValue, TypeReferences.MAP_STRING_OBJECT));
                }
            });
            collection.updateOne(Filters.eq((String)"_id", (Object)doc.getObjectId((Object)"_id")), Updates.set((String)"configuration", config));
        });
        this.saveMigrationCompleted(encryptedFieldsByInputType);
    }

    protected abstract MongoCollection<Document> getCollection();

    protected abstract Map<String, Set<String>> getMigratedField();

    protected abstract void saveMigrationCompleted(Map<String, Set<String>> var1);

    protected Map<String, Set<String>> getEncryptedFieldsByInputType() {
        HashMap<String, Set<String>> encryptedFieldsByInputType = new HashMap<String, Set<String>>();
        this.messageInputFactory.getAvailableInputs().keySet().forEach(type -> {
            Optional<MessageInput.Config> config = this.messageInputFactory.getConfig((String)type);
            config.ifPresent(c -> {
                Set<String> encryptedFields = EncryptedInputConfigs.getEncryptedFields(c);
                if (!encryptedFields.isEmpty()) {
                    encryptedFieldsByInputType.put((String)type, encryptedFields);
                }
            });
        });
        return encryptedFieldsByInputType;
    }
}

