/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.persistence;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.inputs.InputService;
import org.graylog2.inputs.persistence.InputStatusRecord;
import org.graylog2.inputs.persistence.InputStatusService;
import org.graylog2.rest.models.system.inputs.responses.InputDeleted;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MongoInputStatusService
implements InputStatusService {
    private static final Logger LOG = LoggerFactory.getLogger(MongoInputStatusService.class);
    public static final String COLLECTION_NAME = "input_status";
    private final JacksonDBCollection<InputStatusRecord, ObjectId> statusCollection;
    private final InputService inputService;

    @Inject
    public MongoInputStatusService(MongoConnection mongoConnection, MongoJackObjectMapperProvider objectMapperProvider, InputService inputService, EventBus eventBus) {
        this.inputService = inputService;
        DB mongoDatabase = mongoConnection.getDatabase();
        DBCollection collection = mongoDatabase.getCollection(COLLECTION_NAME);
        eventBus.register((Object)this);
        this.statusCollection = JacksonDBCollection.wrap((DBCollection)collection, InputStatusRecord.class, ObjectId.class, (ObjectMapper)objectMapperProvider.get());
    }

    @Override
    public Optional<InputStatusRecord> get(String inputId) {
        return Optional.ofNullable((InputStatusRecord)this.statusCollection.findOneById((Object)new ObjectId(inputId)));
    }

    @Override
    public InputStatusRecord save(InputStatusRecord statusRecord) {
        WriteResult save = this.statusCollection.save((Object)statusRecord);
        return (InputStatusRecord)save.getSavedObject();
    }

    @Override
    public int delete(String inputId) {
        WriteResult delete = this.statusCollection.removeById((Object)new ObjectId(inputId));
        return delete.getN();
    }

    @Subscribe
    public void handleInputDeleted(InputDeleted event) {
        LOG.debug("Input Deleted event received for Input [{}]", (Object)event.id());
        try {
            this.inputService.find(event.id());
        }
        catch (NotFoundException e) {
            LOG.debug("Deleting state for input <{}> from database", (Object)event.id());
            this.delete(event.id());
        }
    }
}

