/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.SortedSet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AllowedAuxiliaryPathChecker {
    private static final Logger LOG = LoggerFactory.getLogger(AllowedAuxiliaryPathChecker.class);
    private final SortedSet<Path> allowedPaths;

    @Inject
    public AllowedAuxiliaryPathChecker(@Named(value="allowed_auxiliary_paths") SortedSet<Path> allowedPaths) {
        this.allowedPaths = allowedPaths;
    }

    public boolean fileIsInAllowedPath(Path path) {
        if (this.allowedPaths.isEmpty()) {
            return true;
        }
        Path realFilePath = AllowedAuxiliaryPathChecker.resolveRealPath(path);
        if (realFilePath == null) {
            return false;
        }
        for (Path allowedPath : this.allowedPaths) {
            Path realAllowedPath = AllowedAuxiliaryPathChecker.resolveRealPath(allowedPath);
            if (realAllowedPath == null || !realFilePath.startsWith(realAllowedPath)) continue;
            return true;
        }
        return false;
    }

    public static Path resolveRealPath(Path path) {
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            LOG.error("Could not resolve real location of path [{}].", (Object)path, (Object)e);
            return null;
        }
    }
}

