/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup;

import com.google.common.base.Suppliers;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog.grn.GRN;
import org.graylog2.contentpacks.ContentPackService;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;

@Singleton
public class Catalog {
    private final Supplier<Map<String, EntityExcerpt>> memoizedExcerptSupplier = Suppliers.memoizeWithExpiration(contentPackService::getEntityExcerpts, (long)5L, (TimeUnit)TimeUnit.SECONDS);

    @Inject
    public Catalog(ContentPackService contentPackService) {
    }

    public Optional<Entry> getEntry(GRN grn) {
        String id = grn.entity();
        Map<String, EntityExcerpt> catalog = this.memoizedExcerptSupplier.get();
        EntityExcerpt excerpt = catalog.get(id);
        if (excerpt != null) {
            return Optional.of(new Entry(id, excerpt.title()));
        }
        return Optional.empty();
    }

    public record Entry(String id, String title) {
    }
}

