/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.adapters.dsvhttp;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class DSVParser {
    private final String ignorechar;
    private final String lineSeparator;
    private final String quoteChar;
    private final boolean keyOnly;
    private final boolean caseInsensitive;
    private final int keyColumn;
    private final int valueColumn;
    private final String splitPattern;

    public DSVParser(String ignorechar, String lineSeparator, String separator, String quoteChar, boolean keyOnly, boolean caseInsensitive, int keyColumn, Optional<Integer> valueColumn) {
        this.ignorechar = ignorechar;
        this.lineSeparator = lineSeparator;
        this.quoteChar = quoteChar;
        this.keyOnly = keyOnly;
        this.caseInsensitive = caseInsensitive;
        this.keyColumn = keyColumn;
        this.valueColumn = valueColumn.orElse(0);
        if (!keyOnly && valueColumn.isEmpty()) {
            throw new IllegalStateException("No value column and not key only parsing specified!");
        }
        this.splitPattern = Strings.isNullOrEmpty((String)quoteChar) ? separator : separator + "(?=(?:[^\\" + quoteChar + "]*\\" + quoteChar + "[^\\" + quoteChar + "]*\\" + quoteChar + ")*[^\\" + quoteChar + "]*$)";
    }

    public Map<String, String> parse(String body) {
        String[] lines;
        ImmutableMap.Builder newLookupBuilder = ImmutableMap.builder();
        for (String line : lines = body.split(this.lineSeparator)) {
            if (line.startsWith(this.ignorechar)) continue;
            String[] values = line.split(this.splitPattern);
            if (values.length <= Math.max(this.keyColumn, this.keyOnly ? 0 : this.valueColumn)) continue;
            String key = this.caseInsensitive ? values[this.keyColumn].toLowerCase(Locale.ENGLISH) : values[this.keyColumn];
            String value = this.keyOnly ? "" : values[this.valueColumn].trim();
            String finalKey = Strings.isNullOrEmpty((String)this.quoteChar) ? key.trim() : key.trim().replaceAll("^" + this.quoteChar + "|" + this.quoteChar + "$", "");
            String finalValue = Strings.isNullOrEmpty((String)this.quoteChar) ? value.trim() : value.trim().replaceAll("^" + this.quoteChar + "|" + this.quoteChar + "$", "");
            newLookupBuilder.put((Object)finalKey, (Object)finalValue);
        }
        return newLookupBuilder.build();
    }
}

