/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.caches;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.inject.assistedinject.Assisted;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.graylog2.lookup.caches.$AutoValue_NullCache_Config;
import org.graylog2.plugin.lookup.LookupCache;
import org.graylog2.plugin.lookup.LookupCacheConfiguration;
import org.graylog2.plugin.lookup.LookupCacheKey;
import org.graylog2.plugin.lookup.LookupResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NullCache
extends LookupCache {
    private static final Logger LOG = LoggerFactory.getLogger(NullCache.class);
    public static final String NAME = "none";

    @Inject
    public NullCache(@Assisted(value="id") String id, @Assisted(value="name") String name, @Assisted LookupCacheConfiguration c, MetricRegistry metricRegistry) {
        super(id, name, c, metricRegistry);
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    public LookupResult get(LookupCacheKey key, Callable<LookupResult> loader) {
        try {
            return loader.call();
        }
        catch (Exception e) {
            LOG.warn("Loading value from data adapter failed for key {}, returning empty result", (Object)key, (Object)e);
            return LookupResult.empty();
        }
    }

    @Override
    public LookupResult getIfPresent(LookupCacheKey key) {
        return LookupResult.empty();
    }

    @Override
    public void purge() {
    }

    @Override
    public void purge(LookupCacheKey purgeKey) {
    }

    @JsonAutoDetect
    @JsonDeserialize(builder=$AutoValue_NullCache_Config.Builder.class)
    @JsonTypeName(value="none")
    @AutoValue
    public static abstract class Config
    implements LookupCacheConfiguration {
        public static Builder builder() {
            return new $AutoValue_NullCache_Config.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonProperty(value="type")
            public abstract Builder type(String var1);

            public abstract Config build();
        }
    }

    public static class Descriptor
    extends LookupCache.Descriptor<Config> {
        public Descriptor() {
            super(NullCache.NAME, Config.class);
        }

        @Override
        public Config defaultConfiguration() {
            return Config.builder().type(NullCache.NAME).build();
        }
    }

    public static interface Factory
    extends LookupCache.Factory {
        public NullCache create(@Assisted(value="id") String var1, @Assisted(value="name") String var2, LookupCacheConfiguration var3);

        @Override
        public Descriptor getDescriptor();
    }
}

