/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.retention.strategies.ClosingRetentionStrategy;
import org.graylog2.indexer.retention.strategies.ClosingRetentionStrategyConfig;
import org.graylog2.indexer.retention.strategies.DeletionRetentionStrategy;
import org.graylog2.indexer.retention.strategies.DeletionRetentionStrategyConfig;
import org.graylog2.indexer.rotation.strategies.MessageCountRotationStrategy;
import org.graylog2.indexer.rotation.strategies.MessageCountRotationStrategyConfig;
import org.graylog2.indexer.rotation.strategies.SizeBasedRotationStrategy;
import org.graylog2.indexer.rotation.strategies.SizeBasedRotationStrategyConfig;
import org.graylog2.indexer.rotation.strategies.TimeBasedRotationStrategy;
import org.graylog2.indexer.rotation.strategies.TimeBasedRotationStrategyConfig;
import org.graylog2.indexer.rotation.strategies.TimeBasedSizeOptimizingStrategy;
import org.graylog2.indexer.rotation.strategies.TimeBasedSizeOptimizingStrategyConfig;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.indexer.retention.RetentionStrategy;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategy;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaintenanceStrategiesHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MaintenanceStrategiesHelper.class);
    private final Map<String, Provider<RotationStrategy>> rotationStrategies;
    private final Map<String, Provider<RetentionStrategy>> retentionStrategies;
    private final ClusterConfigService clusterConfigService;
    private final ElasticsearchConfiguration elasticsearchConfiguration;

    @Inject
    public MaintenanceStrategiesHelper(Map<String, Provider<RotationStrategy>> rotationStrategies, Map<String, Provider<RetentionStrategy>> retentionStrategies, ClusterConfigService clusterConfigService, ElasticsearchConfiguration elasticsearchConfiguration) {
        this.rotationStrategies = rotationStrategies;
        this.retentionStrategies = retentionStrategies;
        this.clusterConfigService = clusterConfigService;
        this.elasticsearchConfiguration = elasticsearchConfiguration;
    }

    public ImmutablePair<String, RotationStrategyConfig> readRotationConfigFromServerConf() {
        switch (this.elasticsearchConfiguration.getRotationStrategy()) {
            case "size": {
                return ImmutablePair.of((Object)SizeBasedRotationStrategy.class.getCanonicalName(), (Object)SizeBasedRotationStrategyConfig.create(this.elasticsearchConfiguration.getMaxSizePerIndex()));
            }
            case "time": {
                return ImmutablePair.of((Object)TimeBasedRotationStrategy.class.getCanonicalName(), (Object)TimeBasedRotationStrategyConfig.builder().rotationPeriod(this.elasticsearchConfiguration.getMaxTimePerIndex()).maxRotationPeriod(this.elasticsearchConfiguration.getMaxWriteIndexAge()).rotateEmptyIndexSet(this.elasticsearchConfiguration.isRotateEmptyIndex()).build());
            }
            case "count": {
                return ImmutablePair.of((Object)MessageCountRotationStrategy.class.getCanonicalName(), (Object)MessageCountRotationStrategyConfig.create(this.elasticsearchConfiguration.getMaxDocsPerIndex()));
            }
            case "time-size-optimizing": {
                return ImmutablePair.of((Object)TimeBasedSizeOptimizingStrategy.class.getCanonicalName(), (Object)TimeBasedSizeOptimizingStrategyConfig.builder().indexLifetimeMin(this.elasticsearchConfiguration.getTimeSizeOptimizingRetentionMinLifeTime()).indexLifetimeMax(this.elasticsearchConfiguration.getTimeSizeOptimizingRetentionMaxLifeTime()).build());
            }
        }
        LOG.warn("Unknown retention strategy [{}]. Defaulting to [{}]", (Object)this.elasticsearchConfiguration.getRotationStrategy(), (Object)"count");
        return ImmutablePair.of((Object)MessageCountRotationStrategy.class.getCanonicalName(), (Object)MessageCountRotationStrategyConfig.create(this.elasticsearchConfiguration.getMaxDocsPerIndex()));
    }

    public ImmutablePair<String, RetentionStrategyConfig> readRetentionConfigFromServerConf() {
        switch (this.elasticsearchConfiguration.getRetentionStrategy()) {
            case "close": {
                return ImmutablePair.of((Object)ClosingRetentionStrategy.class.getCanonicalName(), (Object)ClosingRetentionStrategyConfig.create(this.elasticsearchConfiguration.getMaxNumberOfIndices()));
            }
            case "delete": {
                return ImmutablePair.of((Object)DeletionRetentionStrategy.class.getCanonicalName(), (Object)DeletionRetentionStrategyConfig.create(this.elasticsearchConfiguration.getMaxNumberOfIndices()));
            }
        }
        LOG.warn("Unknown retention strategy [{}]. Defaulting to [{}].", (Object)this.elasticsearchConfiguration.getRetentionStrategy(), (Object)"delete");
        return ImmutablePair.of((Object)DeletionRetentionStrategy.class.getCanonicalName(), (Object)DeletionRetentionStrategyConfig.create(this.elasticsearchConfiguration.getMaxNumberOfIndices()));
    }
}

