/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.mongodb.DuplicateKeyException;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.users.Role;
import org.graylog2.shared.users.UserService;
import org.graylog2.users.RoleImpl;
import org.graylog2.users.RoleService;
import org.graylog2.users.UserServiceImpl;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationHelpers {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationHelpers.class);
    private final RoleService roleService;
    private final UserService userService;

    @Inject
    public MigrationHelpers(RoleService roleService, UserService userService) {
        this.roleService = roleService;
        this.userService = userService;
    }

    @Nullable
    public String ensureBuiltinRole(String roleName, String description, Set<String> expectedPermissions) {
        Role previousRole = null;
        try {
            previousRole = this.roleService.load(roleName);
            if (!previousRole.isReadOnly() || !expectedPermissions.equals(previousRole.getPermissions())) {
                String msg = "Invalid role '" + roleName + "', fixing it.";
                LOG.debug(msg);
                throw new IllegalArgumentException(msg);
            }
        }
        catch (IllegalArgumentException | NoSuchElementException | NotFoundException ignored) {
            LOG.info("{} role is missing or invalid, re-adding it as a built-in role.", (Object)roleName);
            RoleImpl fixedRole = new RoleImpl();
            if (previousRole != null) {
                fixedRole._id = previousRole.getId();
            }
            fixedRole.setReadOnly(true);
            fixedRole.setName(roleName);
            fixedRole.setDescription(description);
            fixedRole.setPermissions(expectedPermissions);
            try {
                Role savedRole = this.roleService.save(fixedRole);
                return savedRole.getId();
            }
            catch (DuplicateKeyException | ValidationException e) {
                LOG.error("Unable to save fixed '" + roleName + "' role, please restart Graylog to fix this.", e);
            }
        }
        if (previousRole == null) {
            LOG.error("Unable to access fixed '" + roleName + "' role, please restart Graylog to fix this.");
            return null;
        }
        return previousRole.getId();
    }

    @Nullable
    public String ensureUser(String userName, String password, String firstName, String lastName, String email, Set<String> expectedRoles) {
        return this.ensureUser(userName, password, firstName, lastName, email, expectedRoles, false);
    }

    @Nullable
    public String ensureUser(String userName, String password, String firstName, String lastName, String email, Set<String> expectedRoles, boolean isServiceAccount) {
        try {
            return this.ensureUserHelper(userName, password, firstName, lastName, email, expectedRoles, isServiceAccount);
        }
        catch (UserServiceImpl.DuplicateUserException e) {
            List<User> users = this.userService.loadAllByName(userName);
            User firstUser = users.remove(0);
            for (User user : users) {
                String uniqueName = user.getName() + "_" + user.getId();
                LOG.warn("Renaming duplicate users {} to {}", (Object)user.getName(), (Object)uniqueName);
                user.setName(uniqueName);
                try {
                    this.userService.save(user);
                }
                catch (ValidationException v) {
                    String msg = "Failed to disambiguate " + userName;
                    LOG.error(msg);
                    throw new IllegalArgumentException(msg);
                }
            }
            return this.ensureUserHelper(userName, password, firstName, lastName, email, expectedRoles, isServiceAccount);
        }
    }

    @Nullable
    public String ensureUserHelper(String userName, String password, String firstName, String lastName, String email, Set<String> expectedRoles, boolean isServiceAccount) {
        User previousUser = null;
        try {
            previousUser = this.userService.load(userName);
            if (previousUser == null || !previousUser.getRoleIds().containsAll(expectedRoles) || !Objects.equals(isServiceAccount, previousUser.isServiceAccount())) {
                String msg = "Invalid user '" + userName + "', fixing it.";
                LOG.debug(msg);
                throw new IllegalArgumentException(msg);
            }
        }
        catch (IllegalArgumentException ignored) {
            User fixedUser;
            LOG.info("{} user is missing or invalid, re-adding it as a built-in user.", (Object)userName);
            if (previousUser != null) {
                fixedUser = previousUser;
                fixedUser.setRoleIds(expectedRoles);
                fixedUser.setServiceAccount(isServiceAccount);
            } else {
                fixedUser = this.userService.create();
                fixedUser.setName(userName);
                fixedUser.setFirstLastFullNames(firstName, lastName);
                fixedUser.setPassword(password);
                fixedUser.setEmail(email);
                fixedUser.setPermissions(Collections.emptyList());
                fixedUser.setRoleIds(expectedRoles);
                fixedUser.setTimeZone(DateTimeZone.UTC);
                fixedUser.setServiceAccount(isServiceAccount);
            }
            try {
                return this.userService.save(fixedUser);
            }
            catch (ValidationException e) {
                LOG.error("Unable to save fixed '" + userName + "' user, please restart Graylog to fix this.", (Throwable)e);
            }
        }
        if (previousUser == null) {
            LOG.error("Unable to access fixed '" + userName + "' user, please restart Graylog to fix this.");
            return null;
        }
        return previousUser.getId();
    }
}

