/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.google.common.base.Preconditions;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.indexset.DefaultIndexSetCreated;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indexset.IndexSetService;
import org.graylog2.indexer.indexset.V20161216123500_Succeeded;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20161216123500_DefaultIndexSetMigration
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20161216123500_DefaultIndexSetMigration.class);
    private final ElasticsearchConfiguration elasticsearchConfiguration;
    private final IndexSetService indexSetService;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public V20161216123500_DefaultIndexSetMigration(ElasticsearchConfiguration elasticsearchConfiguration, IndexSetService indexSetService, ClusterConfigService clusterConfigService) {
        this.elasticsearchConfiguration = elasticsearchConfiguration;
        this.indexSetService = indexSetService;
        this.clusterConfigService = clusterConfigService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.of(2016, 12, 16, 12, 35, 0, 0, ZoneOffset.UTC);
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(V20161216123500_Succeeded.class) != null) {
            return;
        }
        Preconditions.checkState((this.clusterConfigService.get(DefaultIndexSetCreated.class) != null ? 1 : 0) != 0, (Object)"The default index set hasn't been created yet. This is a bug!");
        IndexSetConfig defaultIndexSet = this.indexSetService.getDefault();
        this.migrateIndexSet(defaultIndexSet, this.elasticsearchConfiguration.getDefaultIndexTemplateName());
        List allWithoutDefault = this.indexSetService.findAll().stream().filter(indexSetConfig -> !indexSetConfig.equals(defaultIndexSet)).collect(Collectors.toList());
        for (IndexSetConfig indexSetConfig2 : allWithoutDefault) {
            this.migrateIndexSet(indexSetConfig2, indexSetConfig2.indexPrefix() + "-template");
        }
        this.clusterConfigService.write(V20161216123500_Succeeded.create());
    }

    private void migrateIndexSet(IndexSetConfig indexSetConfig, String templateName) {
        String analyzer = this.elasticsearchConfiguration.getAnalyzer();
        IndexSetConfig updatedConfig = indexSetConfig.toBuilder().indexAnalyzer(analyzer).indexTemplateName(templateName).indexOptimizationMaxNumSegments(this.elasticsearchConfiguration.getIndexOptimizationMaxNumSegments()).indexOptimizationDisabled(this.elasticsearchConfiguration.isDisableIndexOptimization()).build();
        IndexSetConfig savedConfig = this.indexSetService.save(updatedConfig);
        LOG.debug("Successfully updated index set: {}", (Object)savedConfig);
    }
}

