/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog2.grok.GrokPattern;
import org.graylog2.grok.GrokPatternService;
import org.graylog2.migrations.AutoValue_V20191121145100_FixDefaultGrokPatterns_MigrationCompleted;
import org.graylog2.migrations.AutoValue_V20191121145100_FixDefaultGrokPatterns_PatternToMigrate;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.database.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20191121145100_FixDefaultGrokPatterns
extends Migration {
    private static final Logger log = LoggerFactory.getLogger(V20191121145100_FixDefaultGrokPatterns.class);
    private final ClusterConfigService configService;
    private final GrokPatternService grokPatternService;
    @VisibleForTesting
    static final List<PatternToMigrate> patternsToMigrate = ImmutableList.of((Object)PatternToMigrate.builder().name("COMMONAPACHELOG").migrateFrom("%{IPORHOST:clientip} %{HTTPDUSER:ident} %{USER:auth} \\[%{HTTPDATE:timestamp}\\] \"(?:%{WORD:verb} %{NOTSPACE:request}(?: HTTP/%{NUMBER:httpversion})?|%{DATA:rawrequest})\" %{NUMBER:response} (?:%{NUMBER:bytes}|-)").migrateTo("%{IPORHOST:clientip} %{HTTPDUSER:ident} %{USER:auth} \\[%{HTTPDATE:timestamp;date;dd/MMM/yyyy:HH:mm:ss Z}\\] \"(?:%{WORD:verb} %{NOTSPACE:request}(?: HTTP/%{NUMBER:httpversion})?|%{DATA:rawrequest})\" %{NUMBER:response} (?:%{NUMBER:bytes}|-)").build());

    @Inject
    public V20191121145100_FixDefaultGrokPatterns(ClusterConfigService clusterConfigService, GrokPatternService grokPatternService) {
        this.grokPatternService = grokPatternService;
        this.configService = clusterConfigService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2019-11-21T14:51:00Z");
    }

    @Override
    public void upgrade() {
        MigrationCompleted migrationCompleted = this.configService.get(MigrationCompleted.class);
        Set<String> patternNames = patternsToMigrate.stream().map(PatternToMigrate::name).collect(Collectors.toSet());
        if (migrationCompleted != null && migrationCompleted.patterns().containsAll(patternNames)) {
            log.debug("Migration already completed.");
            return;
        }
        try {
            for (PatternToMigrate patternToMigrate : patternsToMigrate) {
                this.migratePattern(patternToMigrate);
            }
            this.configService.write(MigrationCompleted.create(patternNames));
        }
        catch (ValidationException e) {
            log.error("Unable to migrate Grok Pattern.", (Throwable)e);
        }
    }

    private void migratePattern(PatternToMigrate patternToMigrate) throws ValidationException {
        Optional<GrokPattern> currentPattern = this.grokPatternService.loadByName(patternToMigrate.name());
        if (!currentPattern.isPresent()) {
            log.debug("Couldn't find default pattern '{}'. Skipping migration.", (Object)patternToMigrate.name());
            return;
        }
        GrokPattern pattern = currentPattern.get();
        if (!patternToMigrate.migrateFrom().equals(pattern.pattern())) {
            log.info("Skipping migration of modified default Grok Pattern '{}'.", (Object)pattern.name());
        } else {
            log.info("Migrating default Grok Pattern '{}'.", (Object)pattern.name());
            GrokPattern migratedPattern = pattern.toBuilder().pattern(patternToMigrate.migrateTo()).build();
            this.grokPatternService.update(migratedPattern);
        }
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonProperty(value="patterns")
        public abstract Set<String> patterns();

        @JsonCreator
        public static MigrationCompleted create(@JsonProperty(value="patterns") Set<String> patterns) {
            return new AutoValue_V20191121145100_FixDefaultGrokPatterns_MigrationCompleted(patterns);
        }
    }

    @AutoValue
    public static abstract class PatternToMigrate {
        public abstract String name();

        public abstract String migrateFrom();

        public abstract String migrateTo();

        public static Builder builder() {
            return new AutoValue_V20191121145100_FixDefaultGrokPatterns_PatternToMigrate.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder name(String var1);

            public abstract Builder migrateFrom(String var1);

            public abstract Builder migrateTo(String var1);

            public abstract PatternToMigrate build();
        }
    }
}

