/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.auto.value.AutoValue;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.AutoValue_V20200102140000_UnifyEventSeriesId_MigrationCompleted;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20200102140000_UnifyEventSeriesId
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20200102140000_UnifyEventSeriesId.class);
    private final ClusterConfigService clusterConfigService;
    private final MongoCollection<Document> eventDefinitions;

    @Inject
    public V20200102140000_UnifyEventSeriesId(ClusterConfigService clusterConfigService, MongoConnection mongoConnection) {
        this.clusterConfigService = clusterConfigService;
        this.eventDefinitions = mongoConnection.getMongoDatabase().getCollection("event_definitions");
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2020-01-02T14:00:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed.");
            return;
        }
        List<Document> changedEventDefinitions = StreamSupport.stream(this.eventDefinitions.find().spliterator(), false).map(this::unifySeriesId).filter(Objects::nonNull).toList();
        for (Document changedEventDefinition : changedEventDefinitions) {
            ObjectId id = changedEventDefinition.getObjectId((Object)"_id");
            LOG.info("Unified series Id for EventDefinition <{}>", (Object)id);
            this.eventDefinitions.replaceOne(Filters.eq((String)"_id", (Object)id), (Object)changedEventDefinition);
        }
        this.clusterConfigService.write(MigrationCompleted.create());
    }

    private Document unifySeriesId(Document dto) {
        Document config = (Document)dto.get((Object)"config", Document.class);
        if (!config.getString((Object)"type").equals("aggregation-v1")) {
            return null;
        }
        List series = config.getList((Object)"series", Document.class);
        if (series.isEmpty()) {
            return null;
        }
        HashMap<String, String> refMap = new HashMap<String, String>(series.size());
        series.forEach(s -> {
            String id = s.getString((Object)"id");
            String name = s.getString((Object)"function");
            Optional<String> field = Optional.ofNullable(s.getString((Object)"field"));
            String newId = this.toSeriesId(name, field);
            s.put("id", (Object)newId);
            refMap.put(id, newId);
        });
        Document conditions = (Document)config.getEmbedded(List.of("conditions", "expression"), Document.class);
        ObjectId id = config.getObjectId((Object)"_id");
        this.convertConditions(id, refMap, conditions);
        return dto;
    }

    private String toSeriesId(String name, Optional<String> field) {
        return String.format(Locale.US, "%s-%s", name.toLowerCase(Locale.US), field.orElse(""));
    }

    private void convertConditions(ObjectId eventId, Map<String, String> changedIds, Document conditions) {
        Optional.ofNullable(conditions.getString((Object)"expr")).filter(expr -> expr.equals("number-ref")).map(expr -> Optional.ofNullable((String)changedIds.get(conditions.getString((Object)"ref"))).orElseThrow(() -> new RuntimeException(String.format(Locale.US, "Could not resolve new ref for condition on EventDefinition <%s>. oldref <%s> refMap <%s>", eventId, conditions.getString((Object)"ref"), changedIds)))).ifPresent(newRef -> conditions.put("ref", newRef));
        Optional.ofNullable((Document)conditions.get((Object)"left", Document.class)).ifPresent(left -> this.convertConditions(eventId, changedIds, (Document)left));
        Optional.ofNullable((Document)conditions.get((Object)"right", Document.class)).ifPresent(right -> this.convertConditions(eventId, changedIds, (Document)right));
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonCreator
        public static MigrationCompleted create() {
            return new AutoValue_V20200102140000_UnifyEventSeriesId_MigrationCompleted();
        }
    }
}

