/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations.V20200803120800_GrantsMigrations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog.grn.GRNRegistry;
import org.graylog.grn.GRNType;
import org.graylog.grn.GRNTypes;
import org.graylog.plugins.views.search.views.ViewService;
import org.graylog.security.Capability;
import org.graylog.security.DBGrantService;
import org.graylog.security.permissions.CaseSensitiveWildcardPermission;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.Migration;
import org.graylog2.migrations.V20200803120800_GrantsMigrations.AutoValue_GrantsMetaMigration_MigrationCompleted;
import org.graylog2.migrations.V20200803120800_GrantsMigrations.RolesToGrantsMigration;
import org.graylog2.migrations.V20200803120800_GrantsMigrations.UserPermissionsToGrantsMigration;
import org.graylog2.migrations.V20200803120800_GrantsMigrations.ViewOwnerShipToGrantsMigration;
import org.graylog2.migrations.V20200803120800_GrantsMigrations.ViewSharingToGrantsMigration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.shared.users.UserService;
import org.graylog2.users.RoleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrantsMetaMigration
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(GrantsMetaMigration.class);
    private final RoleService roleService;
    private final UserService userService;
    private final DBGrantService dbGrantService;
    private final GRNRegistry grnRegistry;
    private final String rootUsername;
    private final MongoConnection mongoConnection;
    private final ViewService viewService;
    private final ClusterConfigService clusterConfigService;
    public static final Map<Set<String>, GRNTypeCapability> MIGRATION_MAP = ImmutableMap.builder().put((Object)ImmutableSet.of((Object)"dashboards:read", (Object)"dashboards:edit"), (Object)new GRNTypeCapability(GRNTypes.DASHBOARD, Capability.MANAGE)).put((Object)ImmutableSet.of((Object)"dashboards:read"), (Object)new GRNTypeCapability(GRNTypes.DASHBOARD, Capability.VIEW)).put((Object)ImmutableSet.of((Object)"streams:read", (Object)"streams:edit"), (Object)new GRNTypeCapability(GRNTypes.STREAM, Capability.MANAGE)).put((Object)ImmutableSet.of((Object)"streams:read"), (Object)new GRNTypeCapability(GRNTypes.STREAM, Capability.VIEW)).put((Object)ImmutableSet.of((Object)"view:read", (Object)"view:edit"), (Object)new GRNTypeCapability(null, Capability.MANAGE)).put((Object)ImmutableSet.of((Object)"view:read"), (Object)new GRNTypeCapability(null, Capability.VIEW)).put((Object)ImmutableSet.of((Object)"eventdefinitions:read", (Object)"eventdefinitions:edit"), (Object)new GRNTypeCapability(GRNTypes.EVENT_DEFINITION, Capability.MANAGE)).put((Object)ImmutableSet.of((Object)"eventdefinitions:read"), (Object)new GRNTypeCapability(GRNTypes.EVENT_DEFINITION, Capability.VIEW)).build();

    @Inject
    public GrantsMetaMigration(RoleService roleService, UserService userService, DBGrantService dbGrantService, GRNRegistry grnRegistry, @Named(value="root_username") String rootUsername, MongoConnection mongoConnection, ViewService viewService, ClusterConfigService clusterConfigService) {
        this.roleService = roleService;
        this.userService = userService;
        this.dbGrantService = dbGrantService;
        this.grnRegistry = grnRegistry;
        this.rootUsername = rootUsername;
        this.mongoConnection = mongoConnection;
        this.viewService = viewService;
        this.clusterConfigService = clusterConfigService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2020-08-03T12:08:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed.");
            return;
        }
        new ViewSharingToGrantsMigration(this.mongoConnection, this.dbGrantService, this.userService, this.roleService, this.rootUsername, this.viewService, this.grnRegistry).upgrade();
        new RolesToGrantsMigration(this.roleService, this.userService, this.dbGrantService, this.grnRegistry, this.rootUsername).upgrade();
        new ViewOwnerShipToGrantsMigration(this.userService, this.dbGrantService, this.rootUsername, this.viewService, this.grnRegistry).upgrade();
        new UserPermissionsToGrantsMigration(this.userService, this.dbGrantService, this.grnRegistry, this.viewService, this.rootUsername).upgrade();
        this.clusterConfigService.write(MigrationCompleted.create());
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonCreator
        public static MigrationCompleted create() {
            return new AutoValue_GrantsMetaMigration_MigrationCompleted();
        }
    }

    public static class GRNTypeCapability {
        final GRNType grnType;
        final Capability capability;

        public GRNTypeCapability(GRNType grnType, Capability capability) {
            this.grnType = grnType;
            this.capability = capability;
        }
    }

    public static class MigrationWildcardPermission
    extends CaseSensitiveWildcardPermission {
        public MigrationWildcardPermission(String wildcardString) {
            super(wildcardString);
        }

        protected List<Set<String>> getParts() {
            return super.getParts();
        }

        protected String subPart(int idx) {
            return (String)Iterables.getOnlyElement((Iterable)this.getParts().get(idx));
        }
    }
}

