/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import one.util.streamex.EntryStream;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20230113095300_MigrateGlobalPivotLimitsToGroupingsInViews
extends Migration {
    private static final int DEFAULT_LIMIT = 15;
    private static final Logger LOG = LoggerFactory.getLogger(V20230113095300_MigrateGlobalPivotLimitsToGroupingsInViews.class);
    private final ClusterConfigService clusterConfigService;
    private final MongoCollection<Document> views;
    private final Document matchValuePivots = this.doc("config.type", "values");

    @Inject
    public V20230113095300_MigrateGlobalPivotLimitsToGroupingsInViews(MongoConnection mongoConnection, ClusterConfigService clusterConfigService) {
        this.clusterConfigService = clusterConfigService;
        this.views = mongoConnection.getMongoDatabase().getCollection("views");
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2023-01-13T09:53:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed!");
            return;
        }
        List widgetLimitMigrations = StreamSupport.stream(this.views.find().spliterator(), false).flatMap(document -> {
            String viewId = ((ObjectId)document.get((Object)"_id", ObjectId.class)).toHexString();
            Map state = (Map)document.get((Object)"state", Collections.emptyMap());
            return state.entrySet().stream().flatMap(entry -> {
                String queryId = (String)entry.getKey();
                List widgets = (List)((Document)entry.getValue()).get((Object)"widgets", Collections.emptyList());
                return ((EntryStream)EntryStream.of((List)widgets).filter(widget -> "aggregation".equals(((Document)widget.getValue()).getString((Object)"type")))).flatMap(widgetEntry -> {
                    Document widget = (Document)widgetEntry.getValue();
                    Integer widgetIndex = (Integer)widgetEntry.getKey();
                    Document config = (Document)widget.get((Object)"config", (Object)new Document());
                    boolean hasRowLimit = config.containsKey((Object)"row_limit");
                    boolean hasColumnLimit = config.containsKey((Object)"column_limit");
                    Optional<Integer> rowLimit = Optional.ofNullable(config.getInteger((Object)"row_limit"));
                    Optional<Integer> columnLimit = Optional.ofNullable(config.getInteger((Object)"column_limit"));
                    if (widgetIndex != null && (hasRowLimit || hasColumnLimit)) {
                        return Stream.of(new ViewWidgetLimitMigration(viewId, queryId, widgetIndex, rowLimit, columnLimit));
                    }
                    return Stream.empty();
                });
            });
        }).collect(Collectors.toList());
        List operations = widgetLimitMigrations.stream().flatMap(widgetMigration -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add(this.updateView(widgetMigration.viewId, this.doc("$unset", this.doc(this.widgetConfigPath((ViewWidgetLimitMigration)widgetMigration) + ".row_limit", 1))));
            builder.add(this.updateView(widgetMigration.viewId, this.doc("$set", this.doc(this.widgetConfigPath((ViewWidgetLimitMigration)widgetMigration) + ".row_pivots.$[config].config.limit", widgetMigration.rowLimit.orElse(15))), (Bson)this.matchValuePivots));
            builder.add(this.updateView(widgetMigration.viewId, this.doc("$unset", this.doc(this.widgetConfigPath((ViewWidgetLimitMigration)widgetMigration) + ".column_limit", 1))));
            builder.add(this.updateView(widgetMigration.viewId, this.doc("$set", this.doc(this.widgetConfigPath((ViewWidgetLimitMigration)widgetMigration) + ".column_pivots.$[config].config.limit", widgetMigration.columnLimit.orElse(15))), (Bson)this.matchValuePivots));
            return builder.build().stream();
        }).collect(Collectors.toList());
        if (!operations.isEmpty()) {
            LOG.debug("Updating {} widgets ...", (Object)widgetLimitMigrations.size());
            this.views.bulkWrite(operations);
        }
        this.clusterConfigService.write(new MigrationCompleted(widgetLimitMigrations.size()));
    }

    private String widgetConfigPath(ViewWidgetLimitMigration widgetMigration) {
        return "state." + widgetMigration.queryId() + ".widgets." + widgetMigration.widgetIndex() + ".config";
    }

    private WriteModel<Document> updateView(String viewId, Document update, List<Bson> arrayFilters) {
        return new UpdateOneModel(Filters.eq((String)"_id", (Object)new ObjectId(viewId)), (Bson)update, new UpdateOptions().upsert(false).arrayFilters(arrayFilters));
    }

    private WriteModel<Document> updateView(String viewId, Document update, Bson arrayFilters) {
        return this.updateView(viewId, update, Collections.singletonList(arrayFilters));
    }

    private WriteModel<Document> updateView(String viewId, Document update) {
        return this.updateView(viewId, update, (List<Bson>)null);
    }

    private Document doc(String key, Object value) {
        return new Document(key, value);
    }

    public record MigrationCompleted(@JsonProperty(value="migrated_widgets") Integer migratedViews) {
    }

    public record ViewWidgetLimitMigration(String viewId, String queryId, Integer widgetIndex, Optional<Integer> rowLimit, Optional<Integer> columnLimit) {
    }
}

