/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.mongodb.BasicDBObject;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.bson.conversions.Bson;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20230531135500_MigrateRemoveObsoleteItemsFromGrantsCollection
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20230531135500_MigrateRemoveObsoleteItemsFromGrantsCollection.class);
    private final MongoConnection mongoConnection;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public V20230531135500_MigrateRemoveObsoleteItemsFromGrantsCollection(MongoConnection mongoConnection, ClusterConfigService clusterConfigService) {
        this.clusterConfigService = clusterConfigService;
        this.mongoConnection = mongoConnection;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2023-05-31T13:55:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            return;
        }
        HashSet names = new HashSet();
        this.mongoConnection.getMongoDatabase().listCollectionNames().forEach(names::add);
        if (names.contains("grants")) {
            BasicDBObject query = new BasicDBObject("target", (Object)Pattern.compile("^grn::::favorite:"));
            this.mongoConnection.getMongoDatabase().getCollection("grants").deleteMany((Bson)query);
            query = new BasicDBObject("target", (Object)Pattern.compile("^grn::::last_opened:"));
            this.mongoConnection.getMongoDatabase().getCollection("grants").deleteMany((Bson)query);
        }
        this.clusterConfigService.write(new MigrationCompleted());
    }

    public record MigrationCompleted() {
    }
}

