/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.notifications;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.bson.types.ObjectId;
import org.graylog2.audit.AuditActor;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.cluster.Node;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationImpl;
import org.graylog2.notifications.NotificationService;
import org.graylog2.notifications.NotificationSystemEventPublisher;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.system.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class NotificationServiceImpl
extends PersistedServiceImpl
implements NotificationService {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationServiceImpl.class);
    private final NodeId nodeId;
    private final AuditEventSender auditEventSender;
    private final NotificationSystemEventPublisher eventPublisher;

    @Inject
    public NotificationServiceImpl(NodeId nodeId, MongoConnection mongoConnection, AuditEventSender auditEventSender, NotificationSystemEventPublisher eventPublisher) {
        super(mongoConnection);
        this.nodeId = (NodeId)Preconditions.checkNotNull((Object)nodeId);
        this.auditEventSender = auditEventSender;
        this.eventPublisher = eventPublisher;
        this.collection(NotificationImpl.class).createIndex("type");
    }

    @Override
    public Notification build() {
        return new NotificationImpl();
    }

    @Override
    public Notification buildNow() {
        Notification notification = this.build();
        notification.addTimestamp(Tools.nowUTC());
        return notification;
    }

    @Override
    public boolean fixed(Notification.Type type) {
        return this.fixed(type, (Node)null);
    }

    @Override
    public boolean fixed(Notification.Type type, String key) {
        boolean removed;
        BasicDBObject qry = NotificationServiceImpl.typeAndKeyQuery(type, key);
        boolean bl = removed = this.destroyAll(NotificationImpl.class, (DBObject)qry) > 0;
        if (removed) {
            this.auditEventSender.success(AuditActor.system(this.nodeId), "server:system_notification:delete", Map.of("notification_type", type.getDeclaringClass().getCanonicalName()));
        }
        return removed;
    }

    @Override
    public boolean fixed(Notification notification) {
        return this.fixed(notification.getType(), (Node)null);
    }

    @Override
    public boolean fixed(Notification.Type type, Node node) {
        boolean removed;
        BasicDBObject qry = new BasicDBObject();
        qry.put((Object)"type", (Object)type.toString().toLowerCase(Locale.ENGLISH));
        if (node != null) {
            qry.put((Object)"node_id", (Object)node.getNodeId());
        }
        boolean bl = removed = this.destroyAll(NotificationImpl.class, (DBObject)qry) > 0;
        if (removed) {
            this.auditEventSender.success(AuditActor.system(this.nodeId), "server:system_notification:delete", Collections.singletonMap("notification_type", type.getDeclaringClass().getCanonicalName()));
        }
        return removed;
    }

    @Override
    public boolean isFirst(Notification.Type type) {
        return this.isFirst(type, null);
    }

    private boolean isFirst(Notification.Type type, @Nullable String key) {
        BasicDBObject query = NotificationServiceImpl.typeAndKeyQuery(type, key);
        return this.findOne(NotificationImpl.class, (DBObject)query) == null;
    }

    @Override
    public List<Notification> all() {
        List<DBObject> dbObjects = this.query(NotificationImpl.class, (DBObject)new BasicDBObject(), (DBObject)new BasicDBObject("timestamp", (Object)-1));
        ArrayList notifications = Lists.newArrayListWithCapacity((int)dbObjects.size());
        for (DBObject obj : dbObjects) {
            try {
                notifications.add(new NotificationImpl(new ObjectId(obj.get("_id").toString()), obj.toMap()));
            }
            catch (IllegalArgumentException e) {
                LOG.warn("There is a notification type we can't handle: [{}]", obj.get("type"));
            }
        }
        return notifications;
    }

    @Override
    public Optional<Notification> getByTypeAndKey(Notification.Type type, String key) {
        DBObject dbObject = this.findOne(NotificationImpl.class, (DBObject)NotificationServiceImpl.typeAndKeyQuery(type, key));
        if (dbObject != null) {
            return Optional.of(new NotificationImpl(new ObjectId(dbObject.get("_id").toString()), dbObject.toMap()));
        }
        return Optional.empty();
    }

    @Override
    public boolean publishIfFirst(Notification notification) {
        if (notification.getNodeId() == null) {
            notification.addNode(this.nodeId.getNodeId());
        }
        if (notification.getTimestamp() == null) {
            notification.addTimestamp(Tools.nowUTC());
        }
        if (!this.isFirst(notification.getType(), notification.getKey())) {
            return false;
        }
        try {
            this.save(notification);
            this.auditEventSender.success(AuditActor.system(this.nodeId), "server:system_notification:create", notification.asMap());
        }
        catch (ValidationException e) {
            LOG.error("Validating user warning failed.", (Throwable)e);
            this.auditEventSender.failure(AuditActor.system(this.nodeId), "server:system_notification:create", notification.asMap());
            return false;
        }
        return this.eventPublisher.submit(notification);
    }

    @Override
    public int destroyAllByType(Notification.Type type) {
        return this.destroyAll(NotificationImpl.class, (DBObject)NotificationServiceImpl.typeAndKeyQuery(type, null));
    }

    @Override
    public int destroyAllByTypeAndKey(Notification.Type type, @Nullable String key) {
        return this.destroyAll(NotificationImpl.class, (DBObject)NotificationServiceImpl.typeAndKeyQuery(type, key));
    }

    private static BasicDBObject typeAndKeyQuery(Notification.Type type, @Nullable String key) {
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"type", (Object)type.toString().toLowerCase(Locale.ENGLISH));
        if (key != null) {
            query.put((Object)"key", (Object)key);
        }
        return query;
    }
}

