/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin;

import javax.annotation.Nullable;
import org.graylog2.plugin.IOState;
import org.graylog2.plugin.inputs.MessageInput;
import org.slf4j.LoggerFactory;

public class InputFailureRecorder {
    private final IOState<MessageInput> inputState;

    public InputFailureRecorder(IOState<MessageInput> inputState) {
        this.inputState = inputState;
    }

    public void setFailing(Class<?> loggingClass, String error) {
        this.setFailing(loggingClass, error, null);
    }

    public void setFailing(Class<?> loggingClass, String error, @Nullable Throwable e) {
        if (this.inputState.getState().equals((Object)IOState.Type.FAILING)) {
            return;
        }
        if (e != null) {
            this.inputState.setState(IOState.Type.FAILING, error + ": (" + e.getMessage() + ")");
        } else {
            this.inputState.setState(IOState.Type.FAILING, error);
        }
        LoggerFactory.getLogger(loggingClass).warn(error, e);
    }

    public void setRunning() {
        if (this.inputState.getState() == IOState.Type.RUNNING) {
            return;
        }
        this.inputState.setState(IOState.Type.RUNNING);
    }
}

