/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.indexer.searches.timeranges;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.OptionalInt;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.indexer.searches.timeranges.AutoValue_RelativeRange;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@JsonTypeName(value="relative")
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class RelativeRange
extends TimeRange {
    public static final String RELATIVE = "relative";

    @Override
    @JsonProperty
    public String type() {
        return RELATIVE;
    }

    @JsonProperty
    public abstract OptionalInt range();

    @JsonProperty
    public abstract OptionalInt from();

    @JsonProperty
    public abstract OptionalInt to();

    public int getRange() {
        return this.range().orElse(0);
    }

    @Override
    @JsonIgnore
    public DateTime getFrom() {
        if (this.range().isPresent()) {
            int range = this.range().getAsInt();
            return range > 0 ? Tools.nowUTC().minusSeconds(this.range().getAsInt()) : new DateTime(0L, DateTimeZone.UTC);
        }
        return Tools.nowUTC().minusSeconds(this.from().orElseThrow(() -> new IllegalStateException("Neither `range` nor `from` specified!")));
    }

    @Override
    @JsonIgnore
    public DateTime getTo() {
        if (this.range().isPresent()) {
            return Tools.nowUTC();
        }
        return Tools.nowUTC().minusSeconds(this.to().orElse(0));
    }

    @JsonIgnore
    public boolean isAllMessages() {
        return this.range().orElse(-1) == 0;
    }

    public static RelativeRange create(int range) throws InvalidRangeParametersException {
        return Builder.builder().range(range).build();
    }

    public static RelativeRange allTime() {
        try {
            return RelativeRange.create(0);
        }
        catch (InvalidRangeParametersException e) {
            throw new RuntimeException("Unable to create relative timerange for all messages - this should not happen!");
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract RelativeRange autoBuild();

        @JsonProperty(value="range")
        public abstract Builder range(int var1);

        abstract OptionalInt range();

        @JsonProperty(value="from")
        public abstract Builder from(int var1);

        abstract OptionalInt from();

        @JsonProperty(value="to")
        public abstract Builder to(int var1);

        abstract OptionalInt to();

        public RelativeRange build() throws InvalidRangeParametersException {
            if (this.range().isPresent() && (this.from().isPresent() || this.to().isPresent())) {
                throw new InvalidRangeParametersException("Either `range` OR `from`/`to` must be specified, not both!");
            }
            if (this.range().isPresent() && this.range().getAsInt() < 0) {
                throw new InvalidRangeParametersException("Range must not be negative");
            }
            if (this.to().isPresent() && !this.from().isPresent()) {
                throw new InvalidRangeParametersException("If `to` is specified, `from` must be specified to!");
            }
            if (this.from().isPresent() && this.to().isPresent() && this.to().getAsInt() > this.from().getAsInt()) {
                throw new InvalidRangeParametersException("`from` must be greater than `to`!");
            }
            return this.autoBuild();
        }

        @JsonCreator
        public static Builder builder() {
            return new AutoValue_RelativeRange.Builder();
        }
    }
}

