/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.utilities.date;

import com.google.common.collect.Maps;
import com.joestelmach.natty.DateGroup;
import com.joestelmach.natty.Parser;
import java.time.ZoneId;
import java.time.temporal.WeekFields;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.graylog2.plugin.Tools;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class NaturalDateParser {
    private final TimeZone timeZone;
    private final ZoneId zoneId;
    private final DateTimeZone dateTimeZone;
    private final Locale locale;

    public NaturalDateParser() {
        this("Etc/UTC", Locale.getDefault());
    }

    public NaturalDateParser(Locale locale) {
        this("Etc/UTC", locale);
    }

    public NaturalDateParser(String timeZone) throws IllegalArgumentException {
        this(timeZone, Locale.getDefault());
    }

    public NaturalDateParser(String timeZone, Locale locale) throws IllegalArgumentException {
        if (!this.isValidTimeZone(timeZone)) {
            throw new IllegalArgumentException("Invalid timeZone: " + timeZone);
        }
        this.locale = locale;
        this.timeZone = TimeZone.getTimeZone(timeZone);
        this.zoneId = ZoneId.of(timeZone);
        this.dateTimeZone = DateTimeZone.forTimeZone((TimeZone)this.timeZone);
    }

    boolean isValidTimeZone(String timeZone) {
        return Arrays.stream(TimeZone.getAvailableIDs()).anyMatch(id -> id.equals(timeZone));
    }

    boolean matches(String string, String other) {
        return string.equalsIgnoreCase(other.replaceAll("\\s", ""));
    }

    Date alignToStartOf(Date dateToConvert, String string) {
        if (this.matches("lastyear", string) || this.matches("thisyear", string)) {
            return this.alignToStartOfYear(dateToConvert);
        }
        if (this.matches("lastmonth", string) || this.matches("thismonth", string)) {
            return this.alignToStartOfMonth(dateToConvert);
        }
        if (this.matches("lastweek", string) || this.matches("thisweek", string)) {
            return this.alignToStartOfWeek(dateToConvert);
        }
        return this.alignToStartOfDay(dateToConvert);
    }

    Date alignToEndOf(Date dateToConvert, String string) {
        if (this.matches("lastyear", string) || this.matches("thisyear", string)) {
            return this.alignToEndOfYear(dateToConvert);
        }
        if (this.matches("lastmonth", string) || this.matches("thismonth", string)) {
            return this.alignToEndOfMonth(dateToConvert);
        }
        if (this.matches("lastweek", string) || this.matches("thisweek", string)) {
            return this.alignToEndOfWeek(dateToConvert);
        }
        return this.alignToEndOfDay(dateToConvert);
    }

    Date alignToStartOfYear(Date dateToConvert) {
        return Date.from(dateToConvert.toInstant().atZone(this.zoneId).toLocalDate().atStartOfDay().atZone(this.zoneId).withDayOfYear(1).toInstant());
    }

    Date alignToEndOfYear(Date dateToConvert) {
        return Date.from(dateToConvert.toInstant().atZone(this.zoneId).toLocalDate().atStartOfDay().atZone(this.zoneId).withDayOfYear(1).plusYears(1L).toInstant());
    }

    Date alignToStartOfMonth(Date dateToConvert) {
        return Date.from(dateToConvert.toInstant().atZone(this.zoneId).toLocalDate().atStartOfDay().atZone(this.zoneId).withDayOfMonth(1).toInstant());
    }

    Date alignToEndOfMonth(Date dateToConvert) {
        return Date.from(dateToConvert.toInstant().atZone(this.zoneId).toLocalDate().atStartOfDay().atZone(this.zoneId).withDayOfMonth(1).plusMonths(1L).toInstant());
    }

    Date alignToStartOfWeek(Date dateToConvert) {
        return Date.from(dateToConvert.toInstant().atZone(this.zoneId).toLocalDate().atStartOfDay().atZone(this.zoneId).with(WeekFields.of(this.locale).dayOfWeek(), 1L).toInstant());
    }

    Date alignToEndOfWeek(Date dateToConvert) {
        return Date.from(dateToConvert.toInstant().atZone(this.zoneId).toLocalDate().atStartOfDay().atZone(this.zoneId).with(WeekFields.of(this.locale).dayOfWeek(), 7L).plusDays(1L).toInstant());
    }

    Date alignToStartOfDay(Date dateToConvert) {
        return Date.from(dateToConvert.toInstant().atZone(this.zoneId).toLocalDate().atStartOfDay().atZone(this.zoneId).toInstant());
    }

    Date alignToEndOfDay(Date dateToConvert) {
        return Date.from(dateToConvert.toInstant().atZone(this.zoneId).plusDays(1L).toLocalDate().atStartOfDay().atZone(this.zoneId).toInstant());
    }

    public Result parse(String string) throws DateNotParsableException {
        return this.parse(string, new Date());
    }

    Result parse(String string, Date referenceDate) throws DateNotParsableException {
        Date from = null;
        Date to = null;
        Parser parser = new Parser(this.timeZone);
        List groups = parser.parse(string, referenceDate);
        if (!groups.isEmpty()) {
            DateGroup group = (DateGroup)groups.get(0);
            boolean timeIsInferred = group.isTimeInferred();
            List dates = group.getDates();
            Collections.sort(dates);
            if (dates.size() >= 1) {
                Date date = from = timeIsInferred ? this.alignToStartOf((Date)dates.get(0), string) : (Date)dates.get(0);
            }
            to = dates.size() >= 2 ? (timeIsInferred ? this.alignToEndOf((Date)dates.get(1), string) : (Date)dates.get(1)) : (timeIsInferred ? this.alignToEndOf((Date)dates.get(0), string) : null);
        } else {
            throw new DateNotParsableException("Unparsable date: " + string);
        }
        return new Result(from, to, this.dateTimeZone);
    }

    public static class Result {
        private final DateTime from;
        private final DateTime to;
        private final DateTimeZone dateTimeZone;

        public Result(Date from, Date to, DateTimeZone dateTimeZone) {
            this.dateTimeZone = dateTimeZone;
            this.from = from != null ? new DateTime((Object)from, this.dateTimeZone) : Tools.now(this.dateTimeZone);
            this.to = to != null ? new DateTime((Object)to, this.dateTimeZone) : Tools.now(this.dateTimeZone);
        }

        public DateTime getFrom() {
            return this.from;
        }

        public DateTime getTo() {
            return this.to;
        }

        public DateTimeZone getDateTimeZone() {
            return this.dateTimeZone;
        }

        public Map<String, String> asMap() {
            HashMap result = Maps.newHashMap();
            result.put("from", this.dateFormat(this.getFrom()));
            result.put("to", this.dateFormat(this.getTo()));
            result.put("timezone", this.getDateTimeZone().getID());
            return result;
        }

        private String dateFormat(DateTime x) {
            return x.toString(Tools.ES_DATE_FORMAT_NO_MS_FORMATTER.withZone(this.dateTimeZone));
        }
    }

    public static class DateNotParsableException
    extends Exception {
        public DateNotParsableException(String message) {
            super(message);
        }
    }
}

