/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.validate;

import java.util.Map;
import javax.inject.Inject;
import org.graylog2.plugin.validate.ClusterConfigValidator;
import org.graylog2.plugin.validate.ConfigValidationException;

public class ClusterConfigValidatorService {
    private final Map<Class<?>, ClusterConfigValidator> validators;

    @Inject
    public ClusterConfigValidatorService(Map<Class<?>, ClusterConfigValidator> validators) {
        this.validators = validators;
    }

    public void validate(Object configObject) throws ConfigValidationException {
        if (configObject == null) {
            return;
        }
        try {
            Class<?> zclass = configObject.getClass();
            ClusterConfigValidator validator = this.validators.get(zclass);
            if (validator == null) {
                Class<?> zParent = zclass.getSuperclass();
                validator = this.validators.getOrDefault(zParent, obj -> {});
            }
            validator.validate(configObject);
        }
        catch (RuntimeException e) {
            throw new ConfigValidationException(e.getMessage());
        }
    }
}

