/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.entities.preferences.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import javax.inject.Inject;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.rest.resources.entities.preferences.model.StoredEntityListPreferences;
import org.graylog2.rest.resources.entities.preferences.model.StoredEntityListPreferencesId;
import org.graylog2.rest.resources.entities.preferences.service.EntityListPreferencesService;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

public class EntityListPreferencesServiceImpl
implements EntityListPreferencesService {
    public static final String ENTITY_LIST_PREFERENCES_MONGO_COLLECTION_NAME = "entity_list_preferences";
    private final JacksonDBCollection<StoredEntityListPreferences, StoredEntityListPreferencesId> db;

    @Inject
    public EntityListPreferencesServiceImpl(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        this.db = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(ENTITY_LIST_PREFERENCES_MONGO_COLLECTION_NAME), StoredEntityListPreferences.class, StoredEntityListPreferencesId.class, (ObjectMapper)mapper.get(), null);
    }

    @Override
    public StoredEntityListPreferences get(StoredEntityListPreferencesId preferencesId) {
        return (StoredEntityListPreferences)this.db.findOneById((Object)preferencesId);
    }

    @Override
    public boolean save(StoredEntityListPreferences preferences) {
        WriteResult save = this.db.save((Object)preferences);
        return save.getWriteResult().getN() > 0;
    }

    @Override
    public int deleteAllForUser(String userId) {
        BasicDBObject query = new BasicDBObject();
        query.put("_id.user_id", (Object)userId);
        WriteResult result = this.db.remove((DBObject)query);
        return result.getN();
    }
}

