/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.google.common.base.Strings;
import java.net.URI;
import java.util.Date;
import java.util.Optional;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.NewCookie;
import org.graylog2.rest.models.system.sessions.responses.SessionResponse;

public class CookieFactory {
    private static final String HEADER_ORIGIN = "Origin";
    private static final String HEADER_X_FORWARDED_PROTO = "X-Forwarded-Proto";

    NewCookie createAuthenticationCookie(SessionResponse token, ContainerRequestContext requestContext) {
        return this.makeCookie(token.getAuthenticationToken(), token.validUntil(), requestContext);
    }

    NewCookie deleteAuthenticationCookie(ContainerRequestContext requestContext) {
        return this.makeCookie("", new Date(), requestContext);
    }

    private NewCookie makeCookie(String value, Date validUntil, ContainerRequestContext requestContext) {
        Date now = new Date();
        int maxAge = Long.valueOf((validUntil.getTime() - now.getTime()) / 1000L).intValue();
        URI baseUri = this.baseUriFromRequest(requestContext);
        String basePath = Optional.ofNullable(Strings.emptyToNull((String)baseUri.getPath())).orElse("/");
        boolean isSecure = this.schemeFromRequest(requestContext).map(scheme -> scheme.equalsIgnoreCase("https")).orElse(false);
        return new NewCookie("authentication", value, basePath, null, 1, "Authentication Cookie", maxAge, validUntil, isSecure, true);
    }

    private Optional<String> schemeFromRequest(ContainerRequestContext requestContext) {
        Optional<URI> graylogUrlFromHeader = this.uriFromHeader(requestContext, "X-Graylog-Server-URL");
        if (graylogUrlFromHeader.isPresent()) {
            return graylogUrlFromHeader.map(URI::getScheme);
        }
        Optional<String> xForwardedProtoHeader = Optional.ofNullable(requestContext.getHeaderString(HEADER_X_FORWARDED_PROTO)).filter(header -> !Strings.isNullOrEmpty((String)header));
        if (xForwardedProtoHeader.isPresent()) {
            return xForwardedProtoHeader;
        }
        Optional<URI> origin = this.uriFromHeader(requestContext, HEADER_ORIGIN);
        return origin.map(URI::getScheme);
    }

    private Optional<URI> uriFromHeader(ContainerRequestContext requestContext, String headerName) {
        return Optional.ofNullable(requestContext.getHeaderString(headerName)).filter(header -> !Strings.isNullOrEmpty((String)header)).flatMap(this::safeCreateUri);
    }

    private URI baseUriFromRequest(ContainerRequestContext requestContext) {
        Optional<URI> graylogUrlFromHeader = this.uriFromHeader(requestContext, "X-Graylog-Server-URL");
        if (graylogUrlFromHeader.isPresent()) {
            return graylogUrlFromHeader.get();
        }
        Optional<URI> origin = this.uriFromHeader(requestContext, HEADER_ORIGIN);
        return origin.orElseGet(() -> requestContext.getUriInfo().getBaseUri());
    }

    private Optional<URI> safeCreateUri(String uri) {
        try {
            return Optional.of(URI.create(uri));
        }
        catch (IllegalArgumentException ignored) {
            return Optional.empty();
        }
    }
}

