/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Timer;
import com.codahale.metrics.UniformReservoir;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.graylog.plugins.map.config.GeoIpResolverConfig;
import org.graylog.plugins.map.config.S3DownloadException;
import org.graylog.plugins.map.config.S3GeoIpFileService;
import org.graylog.plugins.map.geoip.GeoAsnInformation;
import org.graylog.plugins.map.geoip.GeoIpResolver;
import org.graylog.plugins.map.geoip.GeoIpVendorResolverService;
import org.graylog.plugins.map.geoip.GeoLocationInformation;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.validate.ClusterConfigValidator;
import org.graylog2.plugin.validate.ConfigValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoIpResolverConfigValidator
implements ClusterConfigValidator {
    private static final Logger LOG = LoggerFactory.getLogger(GeoIpResolverConfigValidator.class);
    private static final List<TimeUnit> VALID_UNITS = Arrays.asList(TimeUnit.SECONDS, TimeUnit.MINUTES, TimeUnit.HOURS, TimeUnit.DAYS);
    private final InetAddress testAddress = InetAddress.getLoopbackAddress();
    private final GeoIpVendorResolverService geoIpVendorResolverService;
    private final S3GeoIpFileService s3GeoIpFileService;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public GeoIpResolverConfigValidator(GeoIpVendorResolverService geoIpVendorResolverService, S3GeoIpFileService s3GeoIpFileService, ClusterConfigService clusterConfigService) {
        this.geoIpVendorResolverService = geoIpVendorResolverService;
        this.s3GeoIpFileService = s3GeoIpFileService;
        this.clusterConfigService = clusterConfigService;
    }

    @Override
    public void validate(Object configObject) throws ConfigValidationException {
        if (configObject instanceof GeoIpResolverConfig) {
            GeoIpResolverConfig config = (GeoIpResolverConfig)configObject;
            if (config.enabled()) {
                this.validateConfig(config);
            } else {
                LOG.debug("'{}' is disabled.  Skipping validation", (Object)config);
            }
        } else {
            LOG.warn("'{}' cannot be validated with '{}'.  Validator may have been registered incorrectly.", configObject, this.getClass());
        }
    }

    private void validateConfig(GeoIpResolverConfig config) throws ConfigValidationException {
        Timer timer = new Timer((Reservoir)new UniformReservoir());
        try {
            if (!VALID_UNITS.contains((Object)config.refreshIntervalUnit())) {
                String valid = VALID_UNITS.stream().map(Enum::name).collect(Collectors.joining(","));
                String error = String.format(Locale.ENGLISH, "Invalid '%s'. Valid units are '%s'", "refresh_interval_unit", valid);
                throw new IllegalArgumentException(error);
            }
            GeoIpResolverConfig curConfig = this.clusterConfigService.getOrDefault(GeoIpResolverConfig.class, GeoIpResolverConfig.defaultConfig());
            boolean moveTemporaryFiles = false;
            if (config.useS3()) {
                boolean asnFileExists;
                if (this.s3GeoIpFileService.s3ClientIsNull()) {
                    throw new ConfigValidationException("Unable to use S3 for file refresh without AWS credentials. See documentation for steps to properly configure AWS credentials.");
                }
                boolean bl = asnFileExists = !config.asnDbPath().isEmpty();
                if (config.cityDbPath().startsWith("s3://") && (!asnFileExists || config.asnDbPath().startsWith("s3://"))) {
                    boolean bucketsChanged;
                    boolean bl2 = bucketsChanged = !curConfig.cityDbPath().equals(config.cityDbPath()) || !curConfig.asnDbPath().equals(config.asnDbPath());
                    if (bucketsChanged || this.s3GeoIpFileService.fileRefreshRequired(config)) {
                        this.s3GeoIpFileService.downloadFilesToTempLocation(config);
                        config = config.toBuilder().cityDbPath(this.s3GeoIpFileService.getTempCityFile()).asnDbPath(asnFileExists ? this.s3GeoIpFileService.getTempAsnFile() : "").build();
                        moveTemporaryFiles = true;
                    } else {
                        config = config.toBuilder().cityDbPath(this.s3GeoIpFileService.getActiveCityFile()).asnDbPath(asnFileExists ? this.s3GeoIpFileService.getActiveAsnFile() : "").build();
                    }
                } else {
                    throw new ConfigValidationException("Database file paths must be valid S3 object paths when using S3.");
                }
            }
            this.validateGeoIpLocationResolver(config, timer);
            this.validateGeoIpAsnResolver(config, timer);
            if (moveTemporaryFiles) {
                this.s3GeoIpFileService.moveTempFilesToActive();
            }
        }
        catch (IOException | IllegalArgumentException | IllegalStateException | S3DownloadException e) {
            throw new ConfigValidationException(e.getMessage());
        }
    }

    public void validateGeoIpAsnResolver(GeoIpResolverConfig config, Timer timer) {
        if (config.enabled() && StringUtils.isNotBlank((CharSequence)config.asnDbPath())) {
            GeoIpResolver<GeoAsnInformation> asnResolver = this.geoIpVendorResolverService.createAsnResolver(config, timer);
            if (config.enabled() && !asnResolver.isEnabled()) {
                String msg = String.format(Locale.ENGLISH, "Invalid '%s'  ASN database file '%s'.  Make sure the file exists and is valid for '%1$s'", new Object[]{config.databaseVendorType(), config.asnDbPath()});
                throw new IllegalArgumentException(msg);
            }
            asnResolver.getGeoIpData(this.testAddress);
            if (asnResolver.getLastError().isPresent()) {
                String error = String.format(Locale.ENGLISH, "Error querying ASN.  Make sure you have selected a valid ASN database type for '%s'", new Object[]{config.databaseVendorType()});
                throw new IllegalStateException(error);
            }
        }
    }

    public void validateGeoIpLocationResolver(GeoIpResolverConfig config, Timer timer) {
        GeoIpResolver<GeoLocationInformation> cityResolver = this.geoIpVendorResolverService.createCityResolver(config, timer);
        if (config.enabled() && !cityResolver.isEnabled()) {
            String msg = String.format(Locale.ENGLISH, "Invalid '%s' City Geo IP database file '%s'.  Make sure the file exists and is valid for '%1$s'", new Object[]{config.databaseVendorType(), config.cityDbPath()});
            throw new IllegalArgumentException(msg);
        }
        cityResolver.getGeoIpData(this.testAddress);
        if (cityResolver.getLastError().isPresent()) {
            String error = String.format(Locale.ENGLISH, "Error querying Geo Location.  Make sure you have selected a valid database type for '%s'", new Object[]{config.databaseVendorType()});
            throw new IllegalStateException(error);
        }
    }
}

