/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.SecurityContext;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.graylog2.rest.models.system.sessions.responses.SessionResponse;
import org.graylog2.rest.models.system.sessions.responses.SessionResponseFactory;
import org.graylog2.rest.resources.system.CookieFactory;
import org.graylog2.shared.security.ShiroPrincipal;

public class SlidingExpirationCookieFilter
implements ContainerResponseFilter {
    private final CookieFactory cookieFactory;
    private final SessionResponseFactory sessionResponseFactory;

    @Inject
    public SlidingExpirationCookieFilter(CookieFactory cookieFactory, SessionResponseFactory sessionResponseFactory) {
        this.cookieFactory = cookieFactory;
        this.sessionResponseFactory = sessionResponseFactory;
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (this.noSessionExtension(requestContext)) {
            return;
        }
        this.sessionFromRequest(requestContext).ifPresent(session -> {
            SessionResponse response = this.sessionResponseFactory.forSession((Session)session);
            NewCookie cookie = this.cookieFactory.createAuthenticationCookie(response, requestContext);
            this.setCookie(responseContext, cookie);
        });
    }

    private Optional<Session> sessionFromRequest(ContainerRequestContext requestContext) {
        return Optional.ofNullable(requestContext.getSecurityContext()).map(SecurityContext::getUserPrincipal).filter(p -> p instanceof ShiroPrincipal).map(principal -> ((ShiroPrincipal)principal).getSubject()).filter(Subject::isAuthenticated).map(subject -> subject.getSession(false));
    }

    private boolean noSessionExtension(ContainerRequestContext requestContext) {
        return Optional.ofNullable(requestContext.getHeaderString("X-Graylog-No-Session-Extension")).map("true"::equalsIgnoreCase).orElse(false);
    }

    private void setCookie(ContainerResponseContext responseContext, NewCookie cookie) {
        responseContext.getHeaders().add((Object)"Set-Cookie", (Object)cookie);
    }
}

