/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.debug.bundle;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.shiro.subject.Subject;
import org.graylog2.cluster.NodeService;
import org.graylog2.configuration.IndexerHosts;
import org.graylog2.indexer.cluster.ClusterAdapter;
import org.graylog2.log4j.MemoryAppender;
import org.graylog2.plugin.system.SimpleNodeId;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.rest.models.system.responses.SystemThreadDumpResponse;
import org.graylog2.rest.resources.system.debug.bundle.BundleEntries;
import org.graylog2.rest.resources.system.debug.bundle.BundleFile;
import org.graylog2.rest.resources.system.debug.bundle.LogFile;
import org.graylog2.rest.resources.system.debug.bundle.RemoteSupportBundleInterface;
import org.graylog2.rest.resources.system.debug.bundle.SupportBundleNodeManifest;
import org.graylog2.shared.bindings.providers.ObjectMapperProvider;
import org.graylog2.shared.rest.resources.ProxiedResource;
import org.graylog2.shared.rest.resources.system.RemoteMetricsResource;
import org.graylog2.shared.rest.resources.system.RemoteSystemPluginResource;
import org.graylog2.shared.rest.resources.system.RemoteSystemResource;
import org.graylog2.shared.system.stats.SystemStats;
import org.graylog2.shared.utilities.StringUtils;
import org.graylog2.storage.SearchVersion;
import org.graylog2.storage.versionprobe.VersionProbe;
import org.graylog2.system.stats.ClusterStatsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.http.GET;

public class SupportBundleService {
    public static final int LOGFILE_ENUMERATION_RANGE = 5;
    private static final Logger LOG = LoggerFactory.getLogger(SupportBundleService.class);
    public static final String SUPPORT_BUNDLE_DIR_NAME = "support-bundle";
    public static final Duration CALL_TIMEOUT = Duration.ofSeconds(10L);
    public static final String BUNDLE_NAME_PREFIX = "graylog-support-bundle";
    public static final String IN_MEMORY_LOGFILE_ID = "memory";
    public static final long LOG_COLLECTION_SIZE_LIMIT = 0x3C00000L;
    private final ExecutorService executor;
    private final NodeService nodeService;
    private final RemoteInterfaceProvider remoteInterfaceProvider;
    private final Path bundleDir;
    private final ObjectMapper objectMapper;
    private final ClusterStatsService clusterStatsService;
    private final VersionProbe elasticVersionProbe;
    private final List<URI> elasticsearchHosts;
    private final ClusterAdapter searchDbClusterAdapter;

    @Inject
    public SupportBundleService(@Named(value="proxiedRequestsExecutorService") ExecutorService executor, NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, @Named(value="data_dir") Path dataDir, ObjectMapperProvider objectMapperProvider, ClusterStatsService clusterStatsService, VersionProbe searchDbProbe, @IndexerHosts List<URI> searchDbHosts, ClusterAdapter searchDbClusterAdapter) {
        this.executor = executor;
        this.nodeService = nodeService;
        this.remoteInterfaceProvider = remoteInterfaceProvider;
        this.objectMapper = objectMapperProvider.get();
        this.bundleDir = dataDir.resolve(SUPPORT_BUNDLE_DIR_NAME);
        this.clusterStatsService = clusterStatsService;
        this.elasticVersionProbe = searchDbProbe;
        this.elasticsearchHosts = searchDbHosts;
        this.searchDbClusterAdapter = searchDbClusterAdapter;
    }

    public void buildBundle(HttpHeaders httpHeaders, Subject currentSubject) {
        ProxiedResourceHelper proxiedResourceHelper = new ProxiedResourceHelper(httpHeaders, currentSubject, this.nodeService, this.remoteInterfaceProvider, this.executor);
        Map<String, ProxiedResource.CallResult<SupportBundleNodeManifest>> manifestsResponse = proxiedResourceHelper.requestOnAllNodes(RemoteSupportBundleInterface.class, RemoteSupportBundleInterface::getNodeManifest, CALL_TIMEOUT);
        Map<String, SupportBundleNodeManifest> nodeManifests = this.extractManifests(manifestsResponse);
        Path bundleSpoolDir = null;
        try {
            Path finalSpoolDir = bundleSpoolDir = this.prepareBundleSpoolDir();
            List<CompletableFuture> futures = nodeManifests.entrySet().stream().map(entry -> CompletableFuture.runAsync(() -> this.fetchNodeInfos(proxiedResourceHelper, (String)entry.getKey(), (SupportBundleNodeManifest)entry.getValue(), finalSpoolDir), this.executor)).toList();
            for (CompletableFuture f : futures) {
                f.get();
            }
            this.fetchClusterInfos(proxiedResourceHelper, nodeManifests, bundleSpoolDir);
            this.writeZipFile(bundleSpoolDir);
        }
        catch (Exception e) {
            LOG.warn("Exception while trying to build support bundle", (Throwable)e);
            throw new ServerErrorException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        finally {
            try {
                if (bundleSpoolDir != null) {
                    FileUtils.deleteDirectory((File)bundleSpoolDir.toFile());
                }
            }
            catch (IOException e) {
                LOG.error("Failed to cleanup temp directory <{}>", (Object)bundleSpoolDir);
            }
        }
    }

    private void fetchClusterInfos(ProxiedResourceHelper proxiedResourceHelper, Map<String, SupportBundleNodeManifest> nodeManifests, Path tmpDir) throws IOException {
        try (FileOutputStream clusterJson = new FileOutputStream(tmpDir.resolve("cluster.json").toFile());){
            Map systemOverview = proxiedResourceHelper.requestOnAllNodes(RemoteSystemResource.class, RemoteSystemResource::system, CALL_TIMEOUT);
            Map jvm = proxiedResourceHelper.requestOnAllNodes(RemoteSystemResource.class, RemoteSystemResource::jvm, CALL_TIMEOUT);
            Map processBuffer = proxiedResourceHelper.requestOnAllNodes(RemoteSystemResource.class, RemoteSystemResource::processBufferDump, CALL_TIMEOUT);
            Map installedPlugins = proxiedResourceHelper.requestOnAllNodes(RemoteSystemPluginResource.class, RemoteSystemPluginResource::list, CALL_TIMEOUT);
            HashMap result = new HashMap(Map.of("manifest", nodeManifests, "cluster_system_overview", this.stripCallResult(systemOverview), "jvm", this.stripCallResult(jvm), "process_buffer_dump", this.stripCallResult(processBuffer), "installed_plugins", this.stripCallResult(installedPlugins)));
            result.putAll(this.getClusterInfo());
            this.objectMapper.writerWithDefaultPrettyPrinter().writeValue((OutputStream)clusterJson, result);
        }
    }

    private Map<String, Object> getClusterInfo() {
        ExecutorService executorService = Executors.newFixedThreadPool(3, new ThreadFactoryBuilder().setNameFormat("support-bundle-cluster-info-collector").build());
        ConcurrentHashMap<String, Object> clusterInfo = new ConcurrentHashMap<String, Object>();
        ConcurrentHashMap searchDb = new ConcurrentHashMap();
        CompletionStage clusterStats = this.timeLimitedOrErrorString(this.clusterStatsService::clusterStats, executorService).thenAccept(stats -> clusterInfo.put("cluster_stats", stats));
        CompletionStage searchDbVersion = this.timeLimitedOrErrorString(() -> this.elasticVersionProbe.probe(this.elasticsearchHosts).map(SearchVersion::toString).orElse("Unknown"), executorService).thenAccept(version -> searchDb.put("version", version));
        CompletionStage searchDbStats = this.timeLimitedOrErrorString(this.searchDbClusterAdapter::rawClusterStats, executorService).thenAccept(stats -> searchDb.put("stats", stats));
        try {
            CompletableFuture.allOf(new CompletableFuture[]{clusterStats, searchDbVersion, searchDbStats}).get();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed collecting cluster info", e);
        }
        finally {
            executorService.shutdownNow();
        }
        clusterInfo.put("search_db", searchDb);
        return clusterInfo;
    }

    private CompletableFuture<Object> timeLimitedOrErrorString(Supplier<Object> supplier, Executor executor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(supplier, executor).exceptionally(e -> Optional.ofNullable(e.getLocalizedMessage()).orElse(e.getClass().getSimpleName()))).completeOnTimeout("Timeout after " + CALL_TIMEOUT + "!", CALL_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
    }

    private <T> Map<String, T> stripCallResult(Map<String, ProxiedResource.CallResult<T>> input) {
        return input.entrySet().stream().filter(e -> ((ProxiedResource.CallResult)e.getValue()).response() != null && ((ProxiedResource.CallResult)e.getValue()).response().entity().isPresent()).collect(Collectors.toMap(Map.Entry::getKey, v -> ((ProxiedResource.CallResult)v.getValue()).response().entity().get()));
    }

    private String nowTimestamp() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HHmmss", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat.format(Instant.now().toEpochMilli());
    }

    private void writeZipFile(Path tmpDir) throws IOException {
        Path zipFile = Path.of(".graylog-support-bundle-" + this.nowTimestamp() + ".zip", new String[0]);
        try (ZipOutputStream zipStream = new ZipOutputStream(new FileOutputStream(this.bundleDir.resolve(zipFile).toFile()));
             Stream<Path> walk = Files.walk(tmpDir, new FileVisitOption[0]);){
            walk.filter(p -> !Files.isDirectory(p, new LinkOption[0])).forEach(p -> {
                ZipEntry zipEntry = new ZipEntry(tmpDir.relativize((Path)p).toString());
                try {
                    zipStream.putNextEntry(zipEntry);
                    Files.copy(p, zipStream);
                    zipStream.closeEntry();
                }
                catch (IOException e) {
                    LOG.warn("Failure while creating ZipEntry <{}>", (Object)zipEntry, (Object)e);
                }
            });
        }
        catch (Exception e) {
            Files.delete(zipFile);
            LOG.warn("Failed to create zipfile <{}>", (Object)zipFile, (Object)e);
            throw e;
        }
        Files.move(this.bundleDir.resolve(zipFile), this.bundleDir.resolve(Path.of(zipFile.toString().substring(1), new String[0])), new CopyOption[0]);
    }

    private Path prepareBundleSpoolDir() throws IOException {
        FileAttribute<Set<PosixFilePermission>> userOnlyPermission = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------"));
        Files.createDirectories(this.bundleDir, userOnlyPermission);
        return Files.createTempDirectory(this.bundleDir, ".tmp." + this.nowTimestamp() + ".", userOnlyPermission);
    }

    private Map<String, SupportBundleNodeManifest> extractManifests(Map<String, ProxiedResource.CallResult<SupportBundleNodeManifest>> manifestResponse) {
        return manifestResponse.entrySet().stream().filter(result -> {
            String node = (String)result.getKey();
            ProxiedResource.NodeResponse response = ((ProxiedResource.CallResult)result.getValue()).response();
            if (response == null || !response.isSuccess() || response.entity().isEmpty()) {
                LOG.warn("Missing SupportBundleNodeManifest for Node <{}>", (Object)node);
                return false;
            }
            return true;
        }).collect(Collectors.toMap(Map.Entry::getKey, res -> (SupportBundleNodeManifest)Objects.requireNonNull(((ProxiedResource.CallResult)res.getValue()).response()).entity().get()));
    }

    private void fetchNodeInfos(ProxiedResourceHelper proxiedResourceHelper, String nodeId, SupportBundleNodeManifest manifest, Path tmpDir) {
        Path nodeDir = tmpDir.resolve(new SimpleNodeId(nodeId).getShortNodeId());
        boolean ignored = nodeDir.toFile().mkdirs();
        this.fetchLogs(proxiedResourceHelper, nodeId, manifest.entries().logfiles(), nodeDir);
        this.fetchNodeInfo(proxiedResourceHelper, nodeId, nodeDir);
    }

    private void fetchNodeInfo(ProxiedResourceHelper proxiedResourceHelper, String nodeId, Path nodeDir) {
        try (FileOutputStream threadDumpFile = new FileOutputStream(nodeDir.resolve("thread-dump.txt").toFile());){
            ProxiedResource.NodeResponse dump = proxiedResourceHelper.doNodeApiCall(nodeId, RemoteSystemResource.class, RemoteSystemResource::threadDump, Function.identity(), CALL_TIMEOUT);
            if (dump.entity().isPresent()) {
                threadDumpFile.write(((SystemThreadDumpResponse)dump.entity().get()).threadDump().getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to get threadDump from node <{}>", (Object)nodeId, (Object)e);
        }
        try (FileOutputStream nodeMetricsFile = new FileOutputStream(nodeDir.resolve("metrics.json").toFile());){
            ProxiedResource.NodeResponse metrics = proxiedResourceHelper.doNodeApiCall(nodeId, RemoteMetricsResource.class, c -> c.byNamespace("org"), Function.identity(), CALL_TIMEOUT);
            if (metrics.entity().isPresent()) {
                this.objectMapper.writerWithDefaultPrettyPrinter().writeValue((OutputStream)nodeMetricsFile, metrics.entity().get());
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to get metrics from node <{}>", (Object)nodeId, (Object)e);
        }
        try (FileOutputStream systemStatsFile = new FileOutputStream(nodeDir.resolve("system-stats.json").toFile());){
            ProxiedResource.NodeResponse statsResponse = proxiedResourceHelper.doNodeApiCall(nodeId, RemoteSystemStatsResource.class, RemoteSystemStatsResource::systemStats, Function.identity(), CALL_TIMEOUT);
            if (statsResponse.entity().isPresent()) {
                this.objectMapper.writerWithDefaultPrettyPrinter().writeValue((OutputStream)systemStatsFile, statsResponse.entity().get());
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to get system stats from node <{}>", (Object)nodeId, (Object)e);
        }
    }

    @VisibleForTesting
    List<LogFile> applyBundleSizeLogFileLimit(List<LogFile> allLogs) {
        ImmutableList.Builder truncatedLogFileList = ImmutableList.builder();
        AtomicBoolean oneFileAdded = new AtomicBoolean(false);
        AtomicLong collectedSize = new AtomicLong();
        allLogs.stream().sorted(Comparator.comparing(LogFile::lastModified).reversed()).forEach(logFile -> {
            if (logFile.id().equals(IN_MEMORY_LOGFILE_ID)) {
                truncatedLogFileList.add(logFile);
            } else if (!oneFileAdded.get() || collectedSize.get() < 0x3C00000L) {
                truncatedLogFileList.add(logFile);
                oneFileAdded.set(true);
                collectedSize.addAndGet(logFile.size());
            }
        });
        return truncatedLogFileList.build();
    }

    private void fetchLogs(ProxiedResourceHelper proxiedResourceHelper, String nodeId, List<LogFile> logFiles, Path nodeDir) {
        Path logDir = nodeDir.resolve("logs");
        boolean ignored = logDir.toFile().mkdirs();
        this.applyBundleSizeLogFileLimit(logFiles).forEach(logFile -> {
            block14: {
                try {
                    ProxiedResource.NodeResponse response = proxiedResourceHelper.doNodeApiCall(nodeId, RemoteSupportBundleInterface.class, f -> f.getLogFile(logFile.id()), Function.identity(), CALL_TIMEOUT);
                    if (response.entity().isPresent()) {
                        String logName = Path.of(logFile.name(), new String[0]).getFileName().toString();
                        try (FileOutputStream fileOutputStream = new FileOutputStream(logDir.resolve(logName).toFile());
                             InputStream logFileStream = ((ResponseBody)response.entity().get()).byteStream();){
                            logFileStream.transferTo(fileOutputStream);
                            break block14;
                        }
                    }
                    LOG.warn("Failed to fetch logfile <{}> from node <{}>: Empty response", (Object)logFile.name(), (Object)nodeId);
                }
                catch (IOException e) {
                    LOG.warn("Failed to fetch logfile <{}> from node <{}>", new Object[]{logFile.name(), nodeId, e});
                }
            }
        });
    }

    public SupportBundleNodeManifest getManifest() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        ImmutableList.Builder logFiles = ImmutableList.builder();
        SupportBundleService.getFileAppenders(config).forEach(fileAppender -> this.getRollingFileLogs((RollingFileAppender)fileAppender).forEach(arg_0 -> ((ImmutableList.Builder)logFiles).add(arg_0)));
        Optional<MemoryAppender> memAppender = SupportBundleService.getMemoryAppender(config);
        memAppender.ifPresent(memoryAppender -> this.getMemLogFiles((MemoryAppender)((Object)memoryAppender)).forEach(arg_0 -> ((ImmutableList.Builder)logFiles).add(arg_0)));
        return new SupportBundleNodeManifest(new BundleEntries((List<LogFile>)logFiles.build()));
    }

    private static List<RollingFileAppender> getFileAppenders(Configuration config) {
        return config.getAppenders().values().stream().filter(RollingFileAppender.class::isInstance).map(RollingFileAppender.class::cast).toList();
    }

    private static Optional<MemoryAppender> getMemoryAppender(Configuration config) {
        return config.getAppenders().values().stream().filter(MemoryAppender.class::isInstance).map(MemoryAppender.class::cast).findFirst();
    }

    private List<LogFile> getMemLogFiles(MemoryAppender memAppender) {
        try {
            long logsSize = memAppender.getLogsSize();
            if (logsSize == 0L) {
                return List.of();
            }
            return List.of(new LogFile(IN_MEMORY_LOGFILE_ID, "server.mem.log", logsSize, Instant.now()));
        }
        catch (Exception e) {
            LOG.warn("Failed to get logs from MemoryAppender <{}>", (Object)memAppender.getName(), (Object)e);
            return List.of();
        }
    }

    private List<LogFile> getRollingFileLogs(RollingFileAppender rollingFileAppender) {
        String filePattern = rollingFileAppender.getFilePattern();
        String baseFileName = rollingFileAppender.getFileName();
        ImmutableList.Builder logFiles = ImmutableList.builder();
        this.buildLogFile("0", baseFileName).ifPresent(arg_0 -> ((ImmutableList.Builder)logFiles).add(arg_0));
        String regex = StringUtils.f("^%s\\.%%i\\.gz", baseFileName);
        if (filePattern.matches(regex)) {
            String formatString = filePattern.replace("%i", "%d");
            IntStream.range(1, 5).forEach(i -> {
                String file = StringUtils.f(formatString, i);
                this.buildLogFile(String.valueOf(i), file).ifPresent(arg_0 -> ((ImmutableList.Builder)logFiles).add(arg_0));
            });
        }
        return logFiles.build();
    }

    private Optional<LogFile> buildLogFile(String id, String fileName) {
        try {
            Path filePath = Path.of(fileName, new String[0]);
            long size = Files.size(filePath);
            FileTime lastModifiedTime = Files.getLastModifiedTime(filePath, new LinkOption[0]);
            return Optional.of(new LogFile(id, fileName, size, lastModifiedTime.toInstant()));
        }
        catch (NoSuchFileException ignored) {
            return Optional.empty();
        }
        catch (IOException e) {
            LOG.warn("Failed to read logfile <{}>", (Object)fileName, (Object)e);
            return Optional.empty();
        }
    }

    public void loadLogFileStream(LogFile logFile, OutputStream outputStream) throws IOException {
        if (logFile.id().equals(IN_MEMORY_LOGFILE_ID)) {
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = context.getConfiguration();
            Optional<MemoryAppender> memAppender = SupportBundleService.getMemoryAppender(config);
            if (memAppender.isEmpty()) {
                throw new NotFoundException();
            }
            memAppender.get().streamFormattedLogMessages(outputStream, 0);
        } else {
            Files.copy(Path.of(logFile.name(), new String[0]), outputStream);
        }
    }

    public List<BundleFile> listBundles() {
        List<BundleFile> list;
        block9: {
            Stream<Path> files = Files.walk(this.bundleDir, new FileVisitOption[0]);
            try {
                list = files.filter(p -> !Files.isDirectory(p, new LinkOption[0])).filter(p -> p.getFileName().toString().startsWith(BUNDLE_NAME_PREFIX)).map(f -> {
                    try {
                        return new BundleFile(f.getFileName().toString(), Files.size(f));
                    }
                    catch (IOException e) {
                        LOG.warn("Exception while trying to list support bundles", (Throwable)e);
                        throw new ServerErrorException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
                    }
                }).sorted(Comparator.comparing(BundleFile::fileName).reversed()).collect(Collectors.toList());
                if (files == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException ignored) {
                    return List.of();
                }
                catch (IOException e) {
                    LOG.warn("Exception while trying to list support bundles", (Throwable)e);
                    throw new ServerErrorException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
                }
            }
            files.close();
        }
        return list;
    }

    public void downloadBundle(String filename, OutputStream outputStream) throws IOException {
        this.ensureFileWithinBundleDir(this.bundleDir, filename);
        try {
            Path filePath = this.bundleDir.resolve(filename);
            Files.copy(filePath, outputStream);
        }
        catch (NoSuchFileException e) {
            throw new NotFoundException((Throwable)e);
        }
        catch (Exception e) {
            outputStream.close();
        }
    }

    @VisibleForTesting
    void ensureFileWithinBundleDir(Path bundleDir, String filename) {
        if (!bundleDir.resolve(filename).toAbsolutePath().normalize().startsWith(bundleDir.toAbsolutePath().normalize())) {
            throw new NotFoundException();
        }
    }

    public void deleteBundle(String filename) throws IOException {
        this.ensureFileWithinBundleDir(this.bundleDir, filename);
        Path filePath = this.bundleDir.resolve(filename);
        Files.delete(filePath);
    }

    static class ProxiedResourceHelper
    extends ProxiedResource {
        private final Subject currentSubject;

        protected ProxiedResourceHelper(HttpHeaders httpHeaders, Subject currentSubject, NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, ExecutorService executorService) {
            super(httpHeaders, nodeService, remoteInterfaceProvider, executorService);
            this.currentSubject = currentSubject;
        }

        @Override
        protected Subject getSubject() {
            return this.currentSubject;
        }

        @Override
        protected <RemoteInterfaceType, RemoteCallResponseType, FinalResponseType> ProxiedResource.NodeResponse<FinalResponseType> doNodeApiCall(String nodeId, Class<RemoteInterfaceType> interfaceClass, Function<RemoteInterfaceType, Call<RemoteCallResponseType>> remoteInterfaceFunction, Function<RemoteCallResponseType, FinalResponseType> transformer, Duration timeout) throws IOException {
            return super.doNodeApiCall(nodeId, interfaceClass, remoteInterfaceFunction, transformer, timeout);
        }

        @Override
        protected <RemoteInterfaceType, RemoteCallResponseType> Map<String, ProxiedResource.CallResult<RemoteCallResponseType>> requestOnAllNodes(Class<RemoteInterfaceType> interfaceClass, Function<RemoteInterfaceType, Call<RemoteCallResponseType>> fn, Duration timeout) {
            return super.requestOnAllNodes(interfaceClass, fn, timeout);
        }
    }

    static interface RemoteSystemStatsResource {
        @GET(value="system/stats")
        public Call<SystemStats> systemStats();
    }
}

