/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.field_types;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.indexer.fieldtypes.mapping.FieldTypeMappingsService;
import org.graylog2.indexer.indexset.CustomFieldMapping;
import org.graylog2.indexer.indexset.CustomFieldMappings;
import org.graylog2.rest.resources.system.field_types.FieldTypeChangeRequest;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="System/FieldTypes", tags={"cloud"})
@Path(value="/system/indices/mappings")
@Produces(value={"application/json"})
public class FieldTypeMappingsResource
extends RestResource {
    private final FieldTypeMappingsService fieldTypeMappingsService;

    @Inject
    public FieldTypeMappingsResource(FieldTypeMappingsService fieldTypeMappingsService) {
        this.fieldTypeMappingsService = fieldTypeMappingsService;
    }

    @GET
    @Path(value="/types")
    @Timed
    @ApiOperation(value="Get list of all types valid inside the indexer")
    public Map<String, String> getAllFieldTypes() {
        return CustomFieldMappings.AVAILABLE_TYPES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((CustomFieldMappings.TypeDescription)entry.getValue()).description()));
    }

    @PUT
    @Timed
    @ApiOperation(value="Change field type for certain index sets")
    @ApiResponses(value={@ApiResponse(code=403, message="Unauthorized")})
    @NoAuditEvent(value="No audit for field type changes")
    public Response changeFieldType(@ApiParam(name="request") @Valid @NotNull(message="Request body is mandatory") @Valid @NotNull(message="Request body is mandatory") FieldTypeChangeRequest request) {
        this.checkPermissionsForCreation(request.indexSetsIds());
        CustomFieldMappings.TypeDescription type = CustomFieldMappings.AVAILABLE_TYPES.get(request.type());
        if (type == null) {
            throw new BadRequestException("Invalid type provided: " + request.type() + " - available types: " + CustomFieldMappings.AVAILABLE_TYPES.keySet());
        }
        CustomFieldMapping customMapping = new CustomFieldMapping(request.fieldName(), request.type());
        this.fieldTypeMappingsService.changeFieldType(customMapping, request.indexSetsIds(), request.rotateImmediately());
        return Response.ok().build();
    }

    private void checkPermissionsForCreation(Set<String> indexSetsIds) {
        indexSetsIds.forEach(indexSetId -> this.checkPermission("typemappings:create", (String)indexSetId));
    }
}

