/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.PermittedStreams;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.indexer.indexset.IndexSetFieldTypeSummaryService;
import org.graylog2.rest.models.tools.responses.PageListResponse;
import org.graylog2.rest.resources.entities.Sorting;
import org.graylog2.rest.resources.system.indexer.requests.FieldTypeSummaryRequest;
import org.graylog2.rest.resources.system.indexer.responses.IndexSetFieldTypeSummary;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="System/IndexSets/Types", description="Index set field types", tags={"cloud"})
@Path(value="/system/indices/index_sets/types")
@Produces(value={"application/json"})
public class IndexSetsMappingResource
extends RestResource {
    private final IndexSetFieldTypeSummaryService indexSetFieldTypeSummaryService;
    private final PermittedStreams permittedStreams;

    @Inject
    public IndexSetsMappingResource(IndexSetFieldTypeSummaryService indexSetFieldTypeSummaryService, PermittedStreams permittedStreams) {
        this.indexSetFieldTypeSummaryService = indexSetFieldTypeSummaryService;
        this.permittedStreams = permittedStreams;
    }

    @POST
    @Timed
    @NoAuditEvent(value="No change to the DB")
    @ApiOperation(value="Get field type summaries for given index sets and field")
    public PageListResponse<IndexSetFieldTypeSummary> fieldTypeSummaries(@ApiParam(name="JSON body", required=true) @Valid @NotNull FieldTypeSummaryRequest request, @ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="index_set_id,index_set_title") @DefaultValue(value="index_set_id") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc,desc") @DefaultValue(value="asc") @QueryParam(value="order") String order, @Context SearchUser searchUser) {
        Set<String> streamsIds = this.normalizeStreamIds(request.streamsIds(), searchUser);
        String fieldName = request.fieldName();
        return this.indexSetFieldTypeSummaryService.getIndexSetFieldTypeSummary(streamsIds, fieldName, indexSetId -> this.isPermitted("indexsets:read", (String)indexSetId), page, perPage, sort, Sorting.Direction.valueOf(order.toUpperCase(Locale.ROOT)));
    }

    private Set<String> normalizeStreamIds(Set<String> streams, SearchUser searchUser) {
        return streams == null || streams.isEmpty() ? this.permittedStreams.load(searchUser) : streams;
    }
}

