/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.inputs;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.Configuration;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.inputs.Input;
import org.graylog2.inputs.InputService;
import org.graylog2.inputs.encryption.EncryptedInputConfigs;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.rest.models.system.inputs.requests.InputCreateRequest;
import org.graylog2.rest.models.system.inputs.responses.InputCreated;
import org.graylog2.rest.models.system.inputs.responses.InputSummary;
import org.graylog2.rest.models.system.inputs.responses.InputsList;
import org.graylog2.rest.resources.system.inputs.AbstractInputsResource;
import org.graylog2.shared.inputs.MessageInputFactory;
import org.graylog2.shared.inputs.NoSuchInputTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/Inputs", description="Message inputs", tags={"cloud"})
@Path(value="/system/inputs")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class InputsResource
extends AbstractInputsResource {
    private static final Logger LOG = LoggerFactory.getLogger(InputsResource.class);
    private final InputService inputService;
    private final MessageInputFactory messageInputFactory;
    private final Configuration config;

    @Inject
    public InputsResource(InputService inputService, MessageInputFactory messageInputFactory, Configuration config) {
        super(messageInputFactory.getAvailableInputs());
        this.inputService = inputService;
        this.messageInputFactory = messageInputFactory;
        this.config = config;
    }

    @GET
    @Timed
    @ApiOperation(value="Get information of a single input on this node")
    @Path(value="/{inputId}")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input.")})
    public InputSummary get(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:read", inputId);
        Input input = this.inputService.find(inputId);
        return this.getInputSummary(input);
    }

    @GET
    @Timed
    @ApiOperation(value="Get all inputs")
    public InputsList list() {
        Set<InputSummary> inputs = this.inputService.all().stream().filter(input -> this.isPermitted("inputs:read", input.getId())).map(this::getInputSummary).collect(Collectors.toSet());
        return InputsList.create(inputs);
    }

    @POST
    @Timed
    @ApiOperation(value="Launch input on this node", response=InputCreated.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No such input type registered"), @ApiResponse(code=400, message="Missing or invalid configuration"), @ApiResponse(code=400, message="Type is exclusive and already has input running")})
    @RequiresPermissions(value={"inputs:create"})
    @AuditEvent(type="server:message_input:create")
    public Response create(@ApiParam(name="JSON body", required=true) @Valid @NotNull InputCreateRequest lr) throws ValidationException {
        try {
            this.throwBadRequestIfNotGlobal(lr);
            MessageInput messageInput = this.messageInputFactory.create(lr, this.getCurrentUser().getName(), lr.node());
            if (this.config.isCloud() && !messageInput.isCloudCompatible()) {
                throw new BadRequestException(String.format(Locale.ENGLISH, "The input type <%s> is not allowed in the cloud environment!", lr.type()));
            }
            messageInput.checkConfiguration();
            Input input = this.inputService.create(messageInput.asMap());
            String newId = this.inputService.save(input);
            URI inputUri = this.getUriBuilderToSelf().path(InputsResource.class).path("{inputId}").build(new Object[]{newId});
            return Response.created((URI)inputUri).entity((Object)InputCreated.create(newId)).build();
        }
        catch (NoSuchInputTypeException e) {
            LOG.error("There is no such input type registered.", (Throwable)e);
            throw new NotFoundException("There is no such input type registered.", (Throwable)e);
        }
        catch (ConfigurationException e) {
            LOG.error("Missing or invalid input configuration.", (Throwable)e);
            throw new BadRequestException("Missing or invalid input configuration.", (Throwable)e);
        }
    }

    @DELETE
    @Timed
    @Path(value="/{inputId}")
    @ApiOperation(value="Terminate input on this node")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node.")})
    @AuditEvent(type="server:message_input:delete")
    public void terminate(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:terminate", inputId);
        Input input = this.inputService.find(inputId);
        this.inputService.destroy(input);
    }

    @PUT
    @Timed
    @Path(value="/{inputId}")
    @ApiOperation(value="Update input on this node", response=InputCreated.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node."), @ApiResponse(code=400, message="Missing or invalid input configuration.")})
    @AuditEvent(type="server:message_input:update")
    public Response update(@ApiParam(name="JSON body", required=true) @Valid @NotNull InputCreateRequest lr, @ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) throws org.graylog2.database.NotFoundException, NoSuchInputTypeException, ConfigurationException, ValidationException {
        this.throwBadRequestIfNotGlobal(lr);
        this.checkPermission("inputs:edit", inputId);
        Input input = this.inputService.find(inputId);
        MessageInput messageInput = this.messageInputFactory.create(lr, this.getCurrentUser().getName(), lr.node());
        messageInput.checkConfiguration();
        HashMap<String, Object> mergedInput = new HashMap<String, Object>(input.getFields());
        mergedInput.putAll(messageInput.asMap());
        Map<String, Object> origConfig = input.getConfiguration();
        Map<String, Object> updatedConfig = Objects.requireNonNullElse(messageInput.getConfiguration().getSource(), Map.of());
        mergedInput.put("configuration", EncryptedInputConfigs.merge(origConfig, updatedConfig));
        Input newInput = this.inputService.create(input.getId(), mergedInput);
        this.inputService.update(newInput);
        URI inputUri = this.getUriBuilderToSelf().path(InputsResource.class).path("{inputId}").build(new Object[]{input.getId()});
        return Response.created((URI)inputUri).entity((Object)InputCreated.create(input.getId())).build();
    }

    private void throwBadRequestIfNotGlobal(InputCreateRequest lr) {
        if (this.config.isCloud() && !lr.global()) {
            throw new BadRequestException("Only global inputs are allowed in the cloud environment!");
        }
    }
}

