/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import com.google.common.collect.Iterables;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.graylog.security.certutil.CaService;
import org.graylog.security.certutil.CertificateAuthorityChangedEvent;
import org.graylog.security.certutil.ca.exceptions.KeyStoreStorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomCAX509TrustManager
implements X509TrustManager {
    private static final Logger LOG = LoggerFactory.getLogger(CustomCAX509TrustManager.class);
    private final CaService caService;
    private List<X509TrustManager> trustManagers = new ArrayList<X509TrustManager>();

    @Inject
    public CustomCAX509TrustManager(CaService caService, EventBus serverEventBus) {
        this.caService = caService;
        serverEventBus.register((Object)this);
        this.refresh();
    }

    @Subscribe
    public void handleCertificateAuthorityChange(CertificateAuthorityChangedEvent event) {
        LOG.info("CA changed, refreshing trust manager");
        this.refresh();
    }

    public void refresh() {
        try {
            this.trustManagers = new ArrayList<X509TrustManager>();
            this.trustManagers.add(this.getDefaultTrustManager());
            this.caService.loadKeyStore().ifPresent(keystore -> this.trustManagers.add(this.getTrustManager((KeyStore)keystore)));
        }
        catch (KeyStoreException | NoSuchAlgorithmException | KeyStoreStorageException k) {
            LOG.error("Could not add Graylog CA to TrustManagers: {}", (Object)k.getMessage(), (Object)k);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509TrustManager trustManager : this.trustManagers) {
            try {
                trustManager.checkClientTrusted(chain, authType);
                return;
            }
            catch (CertificateException certificateException) {
            }
        }
        throw new CertificateException("None of the TrustManagers trust this certificate chain.");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509TrustManager trustManager : this.trustManagers) {
            try {
                trustManager.checkServerTrusted(chain, authType);
                return;
            }
            catch (CertificateException certificateException) {
            }
        }
        throw new CertificateException("None of the TrustManagers trust this certificate chain.");
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList certificates = new ArrayList();
        this.trustManagers.forEach(tm -> certificates.addAll(Arrays.asList(tm.getAcceptedIssuers())));
        return certificates.toArray(new X509Certificate[0]);
    }

    private X509TrustManager getDefaultTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        return this.getTrustManager(null);
    }

    private X509TrustManager getTrustManager(KeyStore keystore) {
        try {
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init(keystore);
            return (X509TrustManager)Iterables.getFirst((Iterable)Iterables.filter(Arrays.asList(factory.getTrustManagers()), X509TrustManager.class), null);
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            LOG.error("Could not create TrustManager: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }
}

