/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.bindings;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import java.util.List;

public final class GuiceInjectorHolder {
    private static Injector injector;

    private GuiceInjectorHolder() {
    }

    public static Injector createInjector(List<Module> bindingsModules) {
        if (injector == null) {
            injector = Guice.createInjector((Stage)Stage.PRODUCTION, bindingsModules);
        }
        return injector;
    }

    public static void setInjector(Injector injector) {
        GuiceInjectorHolder.injector = injector;
    }

    public static void resetInjector() {
        injector = null;
    }

    public static Injector getInjector() {
        if (injector == null) {
            throw new IllegalStateException("No injector available. Please call createInjector() first.");
        }
        return injector;
    }
}

