/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.joschi.jadconfig.util.Duration;
import com.google.auto.value.AutoValue;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import okhttp3.ResponseBody;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.shared.rest.resources.AutoValue_ProxiedResource_CallResult;
import org.graylog2.shared.rest.resources.AutoValue_ProxiedResource_MasterResponse;
import org.graylog2.shared.rest.resources.AutoValue_ProxiedResource_NodeResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.utilities.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

public abstract class ProxiedResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(ProxiedResource.class);
    private final String authenticationToken;
    protected final NodeService nodeService;
    protected final RemoteInterfaceProvider remoteInterfaceProvider;
    private final ExecutorService executor;
    @Inject
    @Named(value="proxied_requests_default_call_timeout")
    private Duration defaultProxyCallTimeout;

    protected ProxiedResource(@Context HttpHeaders httpHeaders, NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, ExecutorService executorService) {
        this.nodeService = nodeService;
        this.remoteInterfaceProvider = remoteInterfaceProvider;
        this.executor = executorService;
        this.authenticationToken = ProxiedResource.authenticationToken(httpHeaders);
    }

    protected java.time.Duration getDefaultProxyCallTimeout() {
        return java.time.Duration.ofMillis(Objects.requireNonNull(this.defaultProxyCallTimeout, "defaultProxyCallTimeout not injected").toMilliseconds());
    }

    protected void processAsync(AsyncResponse asyncResponse, Supplier<Object> responseSupplier) {
        Objects.requireNonNull(asyncResponse, "asyncResponse cannot be null");
        Objects.requireNonNull(responseSupplier, "responseSupplier cannot be null");
        asyncResponse.register(disconnected -> LOG.debug("Remote client disconnected"));
        LOG.debug("Schedule async request");
        this.executor.submit(() -> {
            try {
                LOG.debug("Running async request");
                Object response = responseSupplier.get();
                LOG.debug("Resuming async response");
                asyncResponse.resume(response);
            }
            catch (Throwable e) {
                LOG.debug("Async request failed");
                LOG.debug("Resuming async response with an error", e);
                asyncResponse.resume(e);
            }
        });
    }

    public static String authenticationToken(HttpHeaders httpHeaders) {
        List authorizationHeader = httpHeaders.getRequestHeader("Authorization");
        if (authorizationHeader != null && !authorizationHeader.isEmpty()) {
            return (String)authorizationHeader.get(0);
        }
        Cookie authenticationCookie = (Cookie)httpHeaders.getCookies().get("authentication");
        if (authenticationCookie != null) {
            String sessionId = authenticationCookie.getValue();
            String credentials = sessionId + ":session";
            String base64Credentials = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
            return "Basic " + base64Credentials;
        }
        return null;
    }

    @Nullable
    protected String getAuthenticationToken() {
        if (this.getSubject().isAuthenticated()) {
            if (this.authenticationToken == null) {
                throw new NotAuthorizedException((Object)"Basic realm=\"Graylog Server\"", new Object[0]);
            }
            return this.authenticationToken;
        }
        return null;
    }

    @Deprecated
    protected <RemoteInterfaceType, RemoteCallResponseType> Map<String, Optional<RemoteCallResponseType>> getForAllNodes(Function<RemoteInterfaceType, Call<RemoteCallResponseType>> fn, Function<String, Optional<RemoteInterfaceType>> interfaceProvider) {
        return this.getForAllNodes(fn, interfaceProvider, Function.identity(), java.time.Duration.ZERO);
    }

    @Deprecated
    protected <RemoteInterfaceType, RemoteCallResponseType> Map<String, Optional<RemoteCallResponseType>> getForAllNodes(Function<RemoteInterfaceType, Call<RemoteCallResponseType>> fn, Function<String, Optional<RemoteInterfaceType>> interfaceProvider, java.time.Duration timeout) {
        return this.getForAllNodes(fn, interfaceProvider, Function.identity(), timeout);
    }

    @Deprecated
    protected <RemoteInterfaceType, FinalResponseType, RemoteCallResponseType> Map<String, Optional<FinalResponseType>> getForAllNodes(Function<RemoteInterfaceType, Call<RemoteCallResponseType>> fn, Function<String, Optional<RemoteInterfaceType>> interfaceProvider, Function<RemoteCallResponseType, FinalResponseType> transformer) {
        return this.getForAllNodes(fn, interfaceProvider, transformer, java.time.Duration.ZERO);
    }

    @Deprecated
    protected <RemoteInterfaceType, FinalResponseType, RemoteCallResponseType> Map<String, Optional<FinalResponseType>> getForAllNodes(Function<RemoteInterfaceType, Call<RemoteCallResponseType>> fn, Function<String, Optional<RemoteInterfaceType>> interfaceProvider, Function<RemoteCallResponseType, FinalResponseType> transformer, java.time.Duration timeout) {
        long callTimeoutMs = java.time.Duration.ZERO.equals(timeout) ? this.getDefaultProxyCallTimeout().toMillis() : timeout.toMillis();
        Map futures = this.nodeService.allActive().keySet().stream().collect(Collectors.toMap(Function.identity(), node -> ((Optional)interfaceProvider.apply((String)node)).map(r -> this.executor.submit(() -> {
            Call call = (Call)fn.apply(r);
            Stopwatch sw = Stopwatch.createUnstarted();
            try {
                call.timeout().timeout(callTimeoutMs, TimeUnit.MILLISECONDS);
                sw.start();
                Response response = call.execute();
                if (response.isSuccessful()) {
                    return Optional.of(transformer.apply(response.body()));
                }
                LOG.warn("Unable to call {} on node <{}>, result: {} (duration: {} ms)", new Object[]{call.request().url(), node, response.message(), sw.stop().elapsed().toMillis()});
                return Optional.empty();
            }
            catch (IOException e) {
                long elapsedMs = sw.stop().elapsed().toMillis();
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Unable to call {} on node <{}> (duration: {} ms)", new Object[]{call.request().url(), node, elapsedMs, e});
                } else {
                    LOG.warn("Unable to call {} on node <{}>: {} (duration: {} ms)", new Object[]{call.request().url(), node, e.getMessage(), elapsedMs});
                }
                return Optional.empty();
            }
        })).orElse(CompletableFuture.completedFuture(Optional.empty()))));
        return futures.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            try {
                return (Optional)((Future)entry.getValue()).get(callTimeoutMs * 2L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.debug("Couldn't retrieve future", (Throwable)e);
                return Optional.empty();
            }
            catch (TimeoutException e) {
                LOG.debug("Upstream timeout for node <{}>", entry.getKey());
                return Optional.empty();
            }
        }));
    }

    protected <RemoteInterfaceType> Function<String, Optional<RemoteInterfaceType>> createRemoteInterface(Class<RemoteInterfaceType> interfaceClass, @Nullable java.time.Duration timeout) {
        return nodeId -> {
            try {
                Node targetNode = this.nodeService.byNodeId((String)nodeId);
                return Optional.of(this.remoteInterfaceProvider.get(targetNode, this.getAuthenticationToken(), interfaceClass, timeout == null ? this.getDefaultProxyCallTimeout() : timeout));
            }
            catch (NodeNotFoundException e) {
                LOG.warn("Node <" + nodeId + "> not found while trying to call " + interfaceClass.getName() + " on it.");
                return Optional.empty();
            }
        };
    }

    protected <RemoteInterfaceType, RemoteCallResponseType> Map<String, CallResult<RemoteCallResponseType>> requestOnAllNodes(Class<RemoteInterfaceType> interfaceClass, Function<RemoteInterfaceType, Call<RemoteCallResponseType>> fn) {
        return this.requestOnAllNodes(interfaceClass, fn, Function.identity(), null);
    }

    protected <RemoteInterfaceType, RemoteCallResponseType> Map<String, CallResult<RemoteCallResponseType>> requestOnAllNodes(Class<RemoteInterfaceType> interfaceClass, Function<RemoteInterfaceType, Call<RemoteCallResponseType>> fn, java.time.Duration timeout) {
        return this.requestOnAllNodes(interfaceClass, fn, Function.identity(), timeout);
    }

    protected <RemoteInterfaceType, RemoteCallResponseType, FinalResponseType> Map<String, CallResult<FinalResponseType>> requestOnAllNodes(Class<RemoteInterfaceType> interfaceClass, Function<RemoteInterfaceType, Call<RemoteCallResponseType>> remoteInterfaceCallProvider, Function<RemoteCallResponseType, FinalResponseType> responseTransformer) {
        return this.requestOnAllNodes(interfaceClass, remoteInterfaceCallProvider, responseTransformer, null);
    }

    protected <RemoteInterfaceType, RemoteCallResponseType, FinalResponseType> Map<String, CallResult<FinalResponseType>> requestOnAllNodes(Class<RemoteInterfaceType> interfaceClass, Function<RemoteInterfaceType, Call<RemoteCallResponseType>> remoteInterfaceCallProvider, Function<RemoteCallResponseType, FinalResponseType> responseTransformer, @Nullable java.time.Duration timeout) {
        long callTimeoutMs = timeout == null ? this.getDefaultProxyCallTimeout().toMillis() : timeout.toMillis();
        Map futures = this.nodeService.allActive().keySet().stream().collect(Collectors.toMap(Function.identity(), nodeId -> this.executor.submit(() -> {
            Stopwatch sw = Stopwatch.createStarted();
            try {
                return CallResult.success(this.doNodeApiCall((String)nodeId, interfaceClass, remoteInterfaceCallProvider, responseTransformer, timeout));
            }
            catch (Exception e) {
                long elapsedMs = sw.stop().elapsed().toMillis();
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Failed to call API on node <{}>, cause: {} (duration: {} ms)", new Object[]{nodeId, e.getMessage(), elapsedMs, e});
                } else {
                    LOG.warn("Failed to call API on node <{}>, cause: {} (duration: {} ms)", new Object[]{nodeId, e.getMessage(), elapsedMs});
                }
                return CallResult.error(e.getMessage());
            }
        })));
        return futures.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            try {
                return (CallResult)((Future)entry.getValue()).get(callTimeoutMs * 2L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.debug("Couldn't retrieve future", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (TimeoutException e) {
                LOG.debug("Upstream timeout for node <{}>", entry.getKey());
                return CallResult.upstreamTimeout((String)entry.getKey());
            }
        }));
    }

    protected <RemoteInterfaceType, RemoteCallResponseType> NodeResponse<RemoteCallResponseType> requestOnLeader(Function<RemoteInterfaceType, Call<RemoteCallResponseType>> remoteInterfaceFunction, Class<RemoteInterfaceType> interfaceClass, java.time.Duration timeout) throws IOException {
        Node leaderNode = this.nodeService.allActive().values().stream().filter(Node::isLeader).findFirst().orElseThrow(() -> new IllegalStateException("No active leader node found"));
        return this.doNodeApiCall(leaderNode.getNodeId(), interfaceClass, remoteInterfaceFunction, Function.identity(), timeout);
    }

    protected <RemoteInterfaceType, RemoteCallResponseType> NodeResponse<RemoteCallResponseType> requestOnLeader(Function<RemoteInterfaceType, Call<RemoteCallResponseType>> remoteInterfaceFunction, Class<RemoteInterfaceType> interfaceClass) throws IOException {
        return this.requestOnLeader(remoteInterfaceFunction, interfaceClass, this.getDefaultProxyCallTimeout());
    }

    protected <RemoteInterfaceType, RemoteCallResponseType, FinalResponseType> NodeResponse<FinalResponseType> doNodeApiCall(String nodeId, Class<RemoteInterfaceType> interfaceClass, Function<RemoteInterfaceType, Call<RemoteCallResponseType>> remoteInterfaceFunction, Function<RemoteCallResponseType, FinalResponseType> transformer, @Nullable java.time.Duration timeout) throws IOException {
        Function<String, Optional<RemoteInterfaceType>> remoteInterface = this.createRemoteInterface(interfaceClass, timeout);
        RemoteInterfaceType remoteInterfaceType = remoteInterface.apply(nodeId).orElseThrow(() -> new IllegalStateException("Node " + nodeId + " not found"));
        Call<RemoteCallResponseType> call = remoteInterfaceFunction.apply(remoteInterfaceType);
        long callTimeoutMs = timeout == null ? this.getDefaultProxyCallTimeout().toMillis() : timeout.toMillis();
        call.timeout().timeout(callTimeoutMs, TimeUnit.MILLISECONDS);
        Response response = call.execute();
        try (ResponseBody errorBody = response.errorBody();){
            NodeResponse<FinalResponseType> nodeResponse = NodeResponse.create(response.isSuccessful(), response.code(), transformer.apply(response.body()), errorBody == null ? null : errorBody.bytes());
            return nodeResponse;
        }
    }

    protected <T> Map<String, Optional<T>> stripCallResult(Map<String, CallResult<T>> input) {
        return input.entrySet().stream().filter(e -> ((CallResult)e.getValue()).response() != null).collect(Collectors.toMap(Map.Entry::getKey, v -> ((CallResult)v.getValue()).response().entity()));
    }

    @AutoValue
    public static abstract class NodeResponse<ResponseType> {
        @JsonProperty(value="success")
        public abstract boolean isSuccess();

        @JsonProperty(value="code")
        public abstract int code();

        @JsonProperty(value="entity")
        public abstract Optional<ResponseType> entity();

        public abstract Optional<byte[]> error();

        public Object body() {
            return this.entity().isPresent() ? this.entity().get() : this.error().orElse(null);
        }

        @JsonProperty(value="error_text")
        @Nullable
        public String errorText() {
            return this.error().map(bytes -> new String((byte[])bytes, Charset.defaultCharset())).orElse(null);
        }

        public static <ResponseType> NodeResponse<ResponseType> create(boolean isSuccess, int code, @Nullable ResponseType entity, @Nullable byte[] error) {
            return new AutoValue_ProxiedResource_NodeResponse<ResponseType>(isSuccess, code, Optional.ofNullable(entity), Optional.ofNullable(error));
        }
    }

    @AutoValue
    public static abstract class CallResult<ResponseType> {
        @JsonProperty(value="call_executed")
        public abstract boolean isCallExecuted();

        @JsonProperty(value="server_error_message")
        @Nullable
        public abstract String serverErrorMessage();

        @JsonProperty(value="response")
        @Nullable
        public abstract NodeResponse<ResponseType> response();

        public static <ResponseType> CallResult<ResponseType> success(@Nonnull NodeResponse<ResponseType> response) {
            return new AutoValue_ProxiedResource_CallResult<ResponseType>(true, null, response);
        }

        public static <ResponseType> CallResult<ResponseType> error(@Nonnull String serverErrorMessage) {
            return new AutoValue_ProxiedResource_CallResult(false, serverErrorMessage, null);
        }

        public static <ResponseType> CallResult<ResponseType> upstreamTimeout(@Nonnull String nodeId) {
            String msg = StringUtils.f("upstream timeout (node=%s)", nodeId);
            return new AutoValue_ProxiedResource_CallResult(true, msg, null);
        }
    }

    @Deprecated
    @AutoValue
    public static abstract class MasterResponse<ResponseType> {
        public abstract boolean isSuccess();

        public abstract int code();

        public abstract Optional<ResponseType> entity();

        public abstract Optional<byte[]> error();

        public Object body() {
            return this.entity().isPresent() ? this.entity().get() : this.error().orElse(null);
        }

        public static <ResponseType> MasterResponse<ResponseType> create(NodeResponse<ResponseType> nodeResponse) {
            return new AutoValue_ProxiedResource_MasterResponse<ResponseType>(nodeResponse.isSuccess(), nodeResponse.code(), nodeResponse.entity(), nodeResponse.error());
        }
    }
}

