/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources.csp;

import java.lang.reflect.Method;
import javax.inject.Inject;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.FeatureContext;
import org.graylog2.shared.rest.resources.csp.CSP;
import org.graylog2.shared.rest.resources.csp.CSPNonceRequestFilter;
import org.graylog2.shared.rest.resources.csp.CSPResponseFilter;
import org.graylog2.shared.rest.resources.csp.CSPService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSPDynamicFeature
implements DynamicFeature {
    private static final Logger LOG = LoggerFactory.getLogger(CSPDynamicFeature.class);
    public static final String CSP_NONCE_PROPERTY = "cspNonce";
    private final CSPService cspService;

    @Inject
    public CSPDynamicFeature(@Context CSPService cspService) {
        this.cspService = cspService;
    }

    public String cspDefault() {
        return this.cspService.cspString("default");
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        Method resourceMethod = resourceInfo.getResourceMethod();
        Class resourceClass = resourceInfo.getResourceClass();
        if (resourceClass != null && resourceClass.isAnnotationPresent(CSP.class)) {
            context.register((Object)new CSPNonceRequestFilter());
            context.register((Object)new CSPResponseFilter(resourceClass.getAnnotation(CSP.class).group(), this.cspService));
        } else if (resourceMethod != null && resourceMethod.isAnnotationPresent(CSP.class)) {
            context.register((Object)new CSPNonceRequestFilter());
            context.register((Object)new CSPResponseFilter(resourceMethod.getAnnotation(CSP.class).group(), this.cspService));
        }
    }
}

