/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources.csp;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import org.graylog2.shared.rest.resources.csp.CSPService;

public class CSPResponseFilter
implements ContainerResponseFilter {
    public static final String CSP_HEADER = "Content-Security-Policy";
    private static final String noncePattern = "\\{nonce}";
    private String group;
    private final CSPService cspService;

    public CSPResponseFilter(String group, CSPService cspService) {
        this.group = group;
        this.cspService = cspService;
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        MultivaluedMap headers = responseContext.getHeaders();
        if (!headers.containsKey((Object)CSP_HEADER)) {
            String cspNonce = (String)requestContext.getProperty("cspNonce");
            String valueWithNonce = this.cspService.cspString(this.group).replaceAll(noncePattern, cspNonce);
            headers.add((Object)CSP_HEADER, (Object)valueWithNonce);
        }
    }
}

