/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources.csp;

import java.net.URI;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.security.authservice.DBAuthServiceBackendService;
import org.graylog2.configuration.ContentStreamConfiguration;
import org.graylog2.configuration.TelemetryConfiguration;
import org.graylog2.rest.PaginationParameters;
import org.graylog2.shared.rest.resources.csp.CSPResources;
import org.graylog2.shared.rest.resources.csp.CSPService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSPServiceImpl
implements CSPService {
    private static final Logger LOG = LoggerFactory.getLogger(CSPServiceImpl.class);
    private final String telemetryApiHost;
    private final String contentStreamRssApiHost;
    private final DBAuthServiceBackendService dbService;
    private final CSPResources cspResources;

    @Inject
    protected CSPServiceImpl(TelemetryConfiguration telemetryConfiguration, ContentStreamConfiguration contentStreamConfiguration, DBAuthServiceBackendService dbService) {
        this.telemetryApiHost = telemetryConfiguration.getTelemetryApiHost();
        this.dbService = dbService;
        this.cspResources = new CSPResources();
        this.contentStreamRssApiHost = this.getContentStreamHost(contentStreamConfiguration.getContentStreamRssUri());
        this.updateConnectSrc();
    }

    @Override
    public synchronized void updateConnectSrc() {
        String hostList = this.dbService.findPaginated(new PaginationParameters(), x -> true).stream().map(dto -> dto.config().externalHTTPHosts()).filter(Optional::isPresent).map(optList -> String.join((CharSequence)" ", (Iterable)optList.get())).collect(Collectors.joining(" "));
        String connectSrcValue = "'self' " + this.telemetryApiHost + " " + this.contentStreamRssApiHost + " " + hostList;
        this.cspResources.updateAll("connect-src", connectSrcValue);
        LOG.debug("Updated CSP: {}", (Object)connectSrcValue);
    }

    @Override
    public String cspString(String group) {
        return this.cspResources.cspString(group);
    }

    private String getContentStreamHost(URI contentStreamRssApiHost) {
        String slash = "/";
        if (contentStreamRssApiHost.getPath().endsWith(slash)) {
            return contentStreamRssApiHost.toString();
        }
        return contentStreamRssApiHost.toString() + slash;
    }
}

