/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources.system.inputs;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.Configuration;
import org.graylog2.rest.models.system.inputs.responses.InputTypeInfo;
import org.graylog2.rest.models.system.inputs.responses.InputTypesSummary;
import org.graylog2.shared.inputs.InputDescription;
import org.graylog2.shared.inputs.MessageInputFactory;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/Inputs/Types", description="Message input types of this node")
@Path(value="/system/inputs/types")
@Produces(value={"application/json"})
public class InputTypesResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(InputTypesResource.class);
    private final MessageInputFactory messageInputFactory;
    private final Configuration config;

    @Inject
    public InputTypesResource(MessageInputFactory messageInputFactory, Configuration config) {
        this.messageInputFactory = messageInputFactory;
        this.config = config;
    }

    @GET
    @Timed
    @ApiOperation(value="Get all available input types of this node")
    public InputTypesSummary types() {
        HashMap<String, String> types = new HashMap<String, String>();
        for (Map.Entry<String, InputDescription> entry : this.messageInputFactory.getAvailableInputs().entrySet()) {
            if (this.config.isCloud() && !entry.getValue().isCloudCompatible()) continue;
            types.put(entry.getKey(), entry.getValue().getName());
        }
        return InputTypesSummary.create(types);
    }

    @GET
    @Timed
    @Path(value="/all")
    @ApiOperation(value="Get information about all input types")
    public Map<String, InputTypeInfo> all() {
        Map<String, InputDescription> availableTypes = this.messageInputFactory.getAvailableInputs();
        Stream<Object> inputStream = availableTypes.entrySet().stream();
        if (this.config.isCloud()) {
            inputStream = inputStream.filter(e -> ((InputDescription)e.getValue()).isCloudCompatible());
        }
        return inputStream.collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            InputDescription description = (InputDescription)entry.getValue();
            return InputTypeInfo.create((String)entry.getKey(), description.getName(), description.isExclusive(), description.getRequestedConfiguration(), description.getLinkToDocs());
        }));
    }

    @GET
    @Timed
    @Path(value="{inputType}")
    @ApiOperation(value="Get information about a single input type")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input type registered.")})
    public InputTypeInfo info(@ApiParam(name="inputType", required=true) @PathParam(value="inputType") String inputType) {
        InputDescription description = this.messageInputFactory.getAvailableInputs().get(inputType);
        if (description == null) {
            InputTypesResource.throwInputTypeNotFound(inputType);
        } else if (this.config.isCloud() && !description.isCloudCompatible()) {
            InputTypesResource.throwInputTypeNotFound(inputType);
        }
        return InputTypeInfo.create(inputType, description.getName(), description.isExclusive(), description.getRequestedConfiguration(), description.getLinkToDocs());
    }

    private static void throwInputTypeNotFound(String inputType) {
        String message = "Unknown input type " + inputType + " requested.";
        LOG.error(message);
        throw new NotFoundException(message);
    }
}

