/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security;

import java.io.IOException;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import org.graylog2.cluster.leader.LeaderElectionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Priority(value=2000)
public class RestrictToLeaderFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RestrictToLeaderFilter.class);
    private final LeaderElectionService leaderElectionService;

    @Inject
    public RestrictToLeaderFilter(LeaderElectionService leaderElectionService) {
        this.leaderElectionService = leaderElectionService;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (!this.leaderElectionService.isLeader()) {
            LOG.warn("Rejected request to <{}> which is only allowed against leader nodes.", (Object)requestContext.getUriInfo().getPath());
            throw new ForbiddenException("Request is only allowed against leader nodes.");
        }
    }
}

