/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security;

import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;
import org.glassfish.grizzly.http.server.Request;
import org.graylog2.rest.RestTools;
import org.graylog2.shared.security.AccessTokenAuthToken;
import org.graylog2.shared.security.PossibleTrustedHeaderToken;
import org.graylog2.shared.security.SessionIdToken;
import org.graylog2.shared.security.ShiroSecurityContext;
import org.graylog2.utilities.IpSubnet;

@Priority(value=990)
public class ShiroSecurityContextFilter
implements ContainerRequestFilter {
    public static final String SESSION_COOKIE_NAME = "authentication";
    private final DefaultSecurityManager securityManager;
    private final Provider<Request> grizzlyRequestProvider;
    private final Set<IpSubnet> trustedProxies;

    @Inject
    public ShiroSecurityContextFilter(DefaultSecurityManager securityManager, Provider<Request> grizzlyRequestProvider, @Named(value="trusted_proxies") Set<IpSubnet> trustedProxies) {
        this.securityManager = Objects.requireNonNull(securityManager);
        this.grizzlyRequestProvider = grizzlyRequestProvider;
        this.trustedProxies = trustedProxies;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        SecurityContext securityContext;
        ThreadContext.unbindSubject();
        boolean secure = requestContext.getSecurityContext().isSecure();
        MultivaluedMap headers = requestContext.getHeaders();
        Map cookies = requestContext.getCookies();
        Request grizzlyRequest = (Request)this.grizzlyRequestProvider.get();
        String host = RestTools.getRemoteAddrFromRequest(grizzlyRequest, this.trustedProxies);
        String authHeader = (String)headers.getFirst((Object)"Authorization");
        if (authHeader != null && authHeader.startsWith("Basic")) {
            String base64UserPass = authHeader.substring(authHeader.indexOf(32) + 1);
            String userPass = this.decodeBase64(base64UserPass);
            String[] split = userPass.split(":", 2);
            if (split.length != 2) {
                throw new BadRequestException("Invalid credentials in Authorization header");
            }
            securityContext = this.createSecurityContext(split[0], split[1], secure, "BASIC", host, grizzlyRequest.getRemoteAddr(), (MultivaluedMap<String, String>)headers, cookies);
        } else {
            securityContext = this.createSecurityContext(null, null, secure, null, host, grizzlyRequest.getRemoteAddr(), (MultivaluedMap<String, String>)headers, cookies);
        }
        requestContext.setSecurityContext(securityContext);
    }

    private String decodeBase64(String s) {
        try {
            return new String(Base64.getDecoder().decode(s), StandardCharsets.US_ASCII);
        }
        catch (IllegalArgumentException e) {
            return "";
        }
    }

    private SecurityContext createSecurityContext(String userName, String credential, boolean isSecure, String authcScheme, String host, String remoteAddr, MultivaluedMap<String, String> headers, Map<String, Cookie> cookies) {
        AuthenticationToken authToken = this.createAuthenticationToken(userName, credential, host, remoteAddr, cookies);
        Subject subject = new Subject.Builder((SecurityManager)this.securityManager).host(host).sessionCreationEnabled(true).buildSubject();
        return new ShiroSecurityContext(subject, authToken, isSecure, authcScheme, headers);
    }

    private AuthenticationToken createAuthenticationToken(String userName, String credential, String host, String remoteAddr, Map<String, Cookie> cookies) {
        if ("session".equalsIgnoreCase(credential)) {
            return new SessionIdToken(userName, host, remoteAddr);
        }
        if ("token".equalsIgnoreCase(credential)) {
            return new AccessTokenAuthToken(userName, host);
        }
        if (cookies.containsKey(SESSION_COOKIE_NAME)) {
            Cookie authenticationCookie = cookies.get(SESSION_COOKIE_NAME);
            return new SessionIdToken(authenticationCookie.getValue(), host, remoteAddr);
        }
        if (!Strings.isNullOrEmpty((String)userName) && !Strings.isNullOrEmpty((String)credential)) {
            return new UsernamePasswordToken(userName, credential, host);
        }
        return new PossibleTrustedHeaderToken(host, remoteAddr);
    }
}

