/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.system.stats;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.shared.system.stats.SystemStats;
import org.graylog2.shared.system.stats.fs.FsProbe;
import org.graylog2.shared.system.stats.fs.FsStats;
import org.graylog2.shared.system.stats.jvm.JvmProbe;
import org.graylog2.shared.system.stats.jvm.JvmStats;
import org.graylog2.shared.system.stats.network.NetworkProbe;
import org.graylog2.shared.system.stats.network.NetworkStats;
import org.graylog2.shared.system.stats.os.OsProbe;
import org.graylog2.shared.system.stats.os.OsStats;
import org.graylog2.shared.system.stats.process.ProcessProbe;
import org.graylog2.shared.system.stats.process.ProcessStats;

@Singleton
public class StatsService {
    private final FsProbe fsProbe;
    private final JvmProbe jvmProbe;
    private final NetworkProbe networkProbe;
    private final OsProbe osProbe;
    private final ProcessProbe processProbe;

    @Inject
    public StatsService(FsProbe fsProbe, JvmProbe jvmProbe, NetworkProbe networkProbe, OsProbe osProbe, ProcessProbe processProbe) {
        this.fsProbe = fsProbe;
        this.jvmProbe = jvmProbe;
        this.networkProbe = networkProbe;
        this.osProbe = osProbe;
        this.processProbe = processProbe;
    }

    public FsStats fsStats() {
        return this.fsProbe.fsStats();
    }

    public JvmStats jvmStats() {
        return this.jvmProbe.jvmStats();
    }

    public NetworkStats networkStats() {
        return this.networkProbe.networkStats();
    }

    public OsStats osStats() {
        return this.osProbe.osStats();
    }

    public ProcessStats processStats() {
        return this.processProbe.processStats();
    }

    public SystemStats systemStats() {
        return SystemStats.create(this.fsStats(), this.jvmStats(), this.networkStats(), this.osStats(), this.processStats());
    }

    public SystemStats systemStatsWithoutNetwork() {
        return SystemStats.create(this.fsStats(), this.jvmStats(), null, this.osStats(), this.processStats());
    }
}

