/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.system.stats.os;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.shared.system.stats.OshiService;
import org.graylog2.shared.system.stats.os.Memory;
import org.graylog2.shared.system.stats.os.OsProbe;
import org.graylog2.shared.system.stats.os.OsStats;
import org.graylog2.shared.system.stats.os.Processor;
import org.graylog2.shared.system.stats.os.Swap;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.VirtualMemory;
import oshi.util.Util;

@Singleton
public class OshiOsProbe
implements OsProbe {
    private final OshiService service;

    @Inject
    public OshiOsProbe(OshiService service) {
        this.service = service;
    }

    @Override
    public OsStats osStats() {
        HardwareAbstractionLayer hardware = this.service.getHal();
        GlobalMemory globalMemory = hardware.getMemory();
        Memory mem = Memory.create(globalMemory.getTotal(), globalMemory.getAvailable(), this.safePercentage(globalMemory.getAvailable(), globalMemory.getTotal(), 0), globalMemory.getTotal() - globalMemory.getAvailable(), this.safePercentage(globalMemory.getTotal() - globalMemory.getAvailable(), globalMemory.getTotal(), 0), globalMemory.getAvailable(), globalMemory.getTotal() - globalMemory.getAvailable());
        VirtualMemory virtualMemory = globalMemory.getVirtualMemory();
        Swap swap = Swap.create(virtualMemory.getSwapTotal(), virtualMemory.getSwapTotal() - virtualMemory.getSwapUsed(), virtualMemory.getSwapUsed());
        CentralProcessor centralProcessor = hardware.getProcessor();
        long[] prevTicks = centralProcessor.getSystemCpuLoadTicks();
        Util.sleep((long)1000L);
        long[] ticks = centralProcessor.getSystemCpuLoadTicks();
        long user = ticks[CentralProcessor.TickType.USER.getIndex()] - prevTicks[CentralProcessor.TickType.USER.getIndex()];
        long nice = ticks[CentralProcessor.TickType.NICE.getIndex()] - prevTicks[CentralProcessor.TickType.NICE.getIndex()];
        long system = ticks[CentralProcessor.TickType.SYSTEM.getIndex()] - prevTicks[CentralProcessor.TickType.SYSTEM.getIndex()];
        long idle = ticks[CentralProcessor.TickType.IDLE.getIndex()] - prevTicks[CentralProcessor.TickType.IDLE.getIndex()];
        long iowait = ticks[CentralProcessor.TickType.IOWAIT.getIndex()] - prevTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
        long irq = ticks[CentralProcessor.TickType.IRQ.getIndex()] - prevTicks[CentralProcessor.TickType.IRQ.getIndex()];
        long softirq = ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()] - prevTicks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
        long steal = ticks[CentralProcessor.TickType.STEAL.getIndex()] - prevTicks[CentralProcessor.TickType.STEAL.getIndex()];
        long totalCpu = user + nice + system + idle + iowait + irq + softirq + steal;
        totalCpu = totalCpu == 0L ? 1L : totalCpu;
        short sys = (short)(100L * system / totalCpu);
        short us = (short)(100L * user / totalCpu);
        short id = (short)(100L * idle / totalCpu);
        short st = (short)(100L * steal / totalCpu);
        CentralProcessor.ProcessorIdentifier processorIdentifier = centralProcessor.getProcessorIdentifier();
        int totalSockets = centralProcessor.getPhysicalPackageCount() > 0 ? centralProcessor.getPhysicalPackageCount() : 1;
        Processor proc = Processor.create(processorIdentifier.getName(), processorIdentifier.getVendor(), (int)(processorIdentifier.getVendorFreq() / 1000000L), centralProcessor.getLogicalProcessorCount(), centralProcessor.getPhysicalPackageCount(), centralProcessor.getLogicalProcessorCount() / totalSockets, -1L, sys, us, id, st);
        return OsStats.create(centralProcessor.getSystemLoadAverage(3), this.service.getOs().getSystemUptime(), proc, mem, swap);
    }

    private short safePercentage(long nominator, long denominator, int override) {
        return denominator == 0L ? (short)override : (short)(nominator * 100L / denominator);
    }
}

