/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.system.stats.process;

import javax.inject.Inject;
import org.graylog2.shared.system.stats.OshiService;
import org.graylog2.shared.system.stats.process.ProcessProbe;
import org.graylog2.shared.system.stats.process.ProcessStats;
import oshi.software.os.FileSystem;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;

public class OshiProcessProbe
implements ProcessProbe {
    private final OshiService service;

    @Inject
    public OshiProcessProbe(OshiService service) {
        this.service = service;
    }

    @Override
    public ProcessStats processStats() {
        OperatingSystem os = this.service.getOs();
        FileSystem fs = os.getFileSystem();
        long pid = os.getProcessId();
        OSProcess proc = os.getProcess(os.getProcessId());
        ProcessStats.Cpu cpu = ProcessStats.Cpu.create((short)proc.getProcessCpuLoadCumulative(), proc.getKernelTime(), proc.getUserTime(), proc.getUpTime());
        ProcessStats.Memory mem = ProcessStats.Memory.create(proc.getVirtualSize(), proc.getResidentSetSize(), -1L);
        return ProcessStats.create(pid, fs.getOpenFileDescriptors(), fs.getMaxFileDescriptors(), cpu, mem);
    }
}

