/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.users;

import com.google.common.base.Function;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog2.shared.users.Role;

public abstract class Roles {
    @Nonnull
    public static RoleIdToNameFunction roleIdToNameFunction(Map<String, Role> idMap) {
        return new RoleIdToNameFunction(idMap);
    }

    @Nonnull
    public static RoleNameToIdFunction roleNameToIdFunction(Map<String, Role> nameMap) {
        return new RoleNameToIdFunction(nameMap);
    }

    public static RoleToNameFunction roleToNameFunction() {
        return new RoleToNameFunction(false);
    }

    public static RoleToNameFunction roleToNameFunction(boolean lowerCase) {
        return new RoleToNameFunction(lowerCase);
    }

    private static class RoleIdToNameFunction
    implements Function<String, String> {
        private final Map<String, Role> idToRole;

        public RoleIdToNameFunction(Map<String, Role> idToRole) {
            this.idToRole = idToRole;
        }

        @Nullable
        public String apply(String roleId) {
            if (roleId == null || !this.idToRole.containsKey(roleId)) {
                return null;
            }
            return this.idToRole.get(roleId).getName();
        }
    }

    private static class RoleNameToIdFunction
    implements Function<String, String> {
        private final Map<String, Role> nameToRole;

        public RoleNameToIdFunction(Map<String, Role> nameToRole) {
            this.nameToRole = nameToRole;
        }

        @Nullable
        public String apply(@Nullable String roleName) {
            if (roleName == null) {
                return null;
            }
            Role role = this.nameToRole.get(roleName.toLowerCase(Locale.ENGLISH));
            if (role == null) {
                return null;
            }
            return role.getId();
        }
    }

    private static class RoleToNameFunction
    implements Function<Role, String> {
        private final boolean lowerCase;

        public RoleToNameFunction(boolean lowerCase) {
            this.lowerCase = lowerCase;
        }

        @Nullable
        public String apply(@Nullable Role input) {
            if (input != null) {
                String name = input.getName();
                return this.lowerCase ? name.toLowerCase(Locale.ENGLISH) : name;
            }
            return null;
        }
    }
}

