/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.storage;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.graylog2.configuration.validators.SearchVersionRange;
import org.graylog2.shared.utilities.StringUtils;
import org.graylog2.storage.SearchVersion;
import org.graylog2.storage.SupportedSearchVersion;
import org.graylog2.storage.SupportedSearchVersions;
import org.graylog2.storage.providers.ElasticsearchVersionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class SupportedSearchVersionFilter
implements ContainerRequestFilter {
    private final Logger LOG = LoggerFactory.getLogger(SupportedSearchVersionFilter.class);
    private final ResourceInfo resourceInfo;
    private final ElasticsearchVersionProvider versionProvider;

    @Inject
    public SupportedSearchVersionFilter(@Context ResourceInfo resourceInfo, ElasticsearchVersionProvider versionProvider) {
        this.resourceInfo = resourceInfo;
        this.versionProvider = versionProvider;
    }

    private void checkVersion(SupportedSearchVersion[] annotations) {
        Set<SearchVersionRange> supportedVersions = Arrays.stream(annotations).map(supportedVersion -> SearchVersionRange.of(supportedVersion.distribution(), supportedVersion.version())).collect(Collectors.toSet());
        String supportedVersionsString = supportedVersions.stream().map(version -> StringUtils.f("%s %s", new Object[]{version.distribution(), version.expression()})).collect(Collectors.joining(", "));
        SearchVersion currentVersion = this.versionProvider.get();
        this.LOG.debug("Checking current version {} satisfies required version [{}]", (Object)currentVersion, (Object)supportedVersionsString);
        if (!currentVersion.satisfies(supportedVersions)) {
            String errMsg = StringUtils.f("Server search version %s is not compatible with resource. Supported versions: [%s]", currentVersion, supportedVersionsString);
            this.LOG.error(errMsg);
            throw new InternalServerErrorException(errMsg);
        }
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (this.resourceInfo.getResourceMethod().isAnnotationPresent(SupportedSearchVersion.class) || this.resourceInfo.getResourceMethod().isAnnotationPresent(SupportedSearchVersions.class)) {
            this.checkVersion((SupportedSearchVersion[])this.resourceInfo.getResourceMethod().getAnnotationsByType(SupportedSearchVersion.class));
        } else if (this.resourceInfo.getResourceClass().isAnnotationPresent(SupportedSearchVersion.class) || this.resourceInfo.getResourceClass().isAnnotationPresent(SupportedSearchVersions.class)) {
            this.checkVersion((SupportedSearchVersion[])this.resourceInfo.getResourceClass().getAnnotationsByType(SupportedSearchVersion.class));
        }
    }
}

