/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.telemetry.user.db;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.DBCollection;
import java.util.Optional;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.telemetry.user.db.TelemetryUserSettingsDto;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;

public class DBTelemetryUserSettingsService {
    public static final String COLLECTION_NAME = "telemetry_user_settings";
    private final JacksonDBCollection<TelemetryUserSettingsDto, ObjectId> db;

    @Inject
    public DBTelemetryUserSettingsService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        this.db = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(COLLECTION_NAME), TelemetryUserSettingsDto.class, ObjectId.class, (ObjectMapper)mapper.get());
    }

    public Optional<TelemetryUserSettingsDto> findByUserId(String userId) {
        return Optional.ofNullable((TelemetryUserSettingsDto)this.db.findOne(DBQuery.is((String)"user_id", (Object)userId)));
    }

    public void save(TelemetryUserSettingsDto dto) {
        this.db.save((Object)dto);
    }

    public void delete(String userId) {
        this.db.remove(DBQuery.is((String)"user_id", (Object)userId));
    }
}

